/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.comment;

import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class Comment
implements Statement {
    private Table table;
    private Column column;
    private Table view;
    private StringValue comment;

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table view) {
        this.view = view;
    }

    public StringValue getComment() {
        return this.comment;
    }

    public void setComment(StringValue comment) {
        this.comment = comment;
    }

    public String toString() {
        Object sql = "COMMENT ON ";
        if (this.table != null) {
            sql = (String)sql + "TABLE " + this.table + " ";
        } else if (this.column != null) {
            sql = (String)sql + "COLUMN " + this.column + " ";
        } else if (this.view != null) {
            sql = (String)sql + "VIEW " + this.view + " ";
        }
        sql = (String)sql + "IS " + this.comment;
        return sql;
    }

    public Comment withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Comment withColumn(Column column) {
        this.setColumn(column);
        return this;
    }

    public Comment withComment(StringValue comment) {
        this.setComment(comment);
        return this;
    }
}

