/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class TestDFSNetworkTopologyPerformance {
    public static final Logger LOG = LoggerFactory.getLogger(TestDFSNetworkTopologyPerformance.class);
    private static NetworkTopology cluster;
    private static DFSNetworkTopology dfscluster;
    private DatanodeDescriptor[] dataNodes;
    private static final int NODE_NUM = 2000;
    private static final int OP_NUM = 20000;
    private static final int L1_NUM = 5;
    private static final int L2_NUM = 10;
    private static final int L3_NUM = 10;
    private static final float NS_TO_MS = 1000000.0f;
    private static final Random RANDOM;
    private Node node;
    private long totalStart;
    private long totalEnd;
    private int totalTrials;
    private float totalMs;
    private Set<Node> excluded;
    private static String[] racks;
    private static String[] hosts;
    private static StorageType[] types;
    private static long[] records;
    private long localStart;
    private long localEnd;

    @BeforeClass
    public static void init() throws Exception {
        racks = new String[2000];
        hosts = new String[2000];
        types = new StorageType[2000];
        records = new long[20000];
        for (int i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.racks[i] = TestDFSNetworkTopologyPerformance.getRandLocation();
            TestDFSNetworkTopologyPerformance.hosts[i] = "host" + i;
        }
    }

    @Before
    public void setup() throws Exception {
        cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        dfscluster = DFSNetworkTopology.getInstance((Configuration)new Configuration());
        this.excluded = new HashSet<Node>();
    }

    @Test
    public void testUniformStorageType() throws Exception {
        int i;
        EnumSet<StorageType> missingTypes = EnumSet.allOf(StorageType.class);
        for (i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.types[i] = this.getRandType();
            missingTypes.remove(types);
        }
        if (missingTypes.size() != 0) {
            HashSet<Integer> usedIdx = new HashSet<Integer>();
            for (StorageType type : missingTypes) {
                int idx;
                while (usedIdx.contains(idx = RANDOM.nextInt(2000))) {
                }
                usedIdx.add(idx);
                TestDFSNetworkTopologyPerformance.types[idx] = type;
            }
        }
        this.addNodeByTypes(types);
        Thread.sleep(1000L);
        this.printMemUsage("before test1");
        this.totalStart = System.nanoTime();
        this.totalTrials = 0;
        for (i = 0; i < 20000; ++i) {
            StorageType type = StorageType.values()[i % StorageType.values().length];
            this.localStart = System.nanoTime();
            while (true) {
                ++this.totalTrials;
                this.node = cluster.chooseRandom("", this.excluded);
                Assert.assertNotNull((Object)this.node);
                if (this.isType(this.node, type)) break;
                this.excluded.add(this.node);
            }
            this.excluded.clear();
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {} avg trials: {}", new Object[]{Float.valueOf(this.totalMs), Float.valueOf(this.totalMs / 20000.0f), Float.valueOf((float)this.totalTrials / 20000.0f)});
        Thread.sleep(1000L);
        this.printMemUsage("after test1 before test2");
        this.totalStart = System.nanoTime();
        for (i = 0; i < 20000; ++i) {
            StorageType type = StorageType.values()[i % StorageType.values().length];
            this.localStart = System.nanoTime();
            this.node = dfscluster.chooseRandomWithStorageType("", this.excluded, type);
            Assert.assertNotNull((Object)this.node);
            Assert.assertTrue((boolean)this.isType(this.node, type));
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {}", (Object)Float.valueOf(this.totalMs), (Object)Float.valueOf(this.totalMs / 20000.0f));
        this.printMemUsage("after test2");
    }

    @Test
    public void testUnbalancedStorageType() throws Exception {
        int i;
        for (i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.types[i] = StorageType.DISK;
        }
        for (i = 0; i < 100; ++i) {
            TestDFSNetworkTopologyPerformance.types[TestDFSNetworkTopologyPerformance.RANDOM.nextInt((int)2000)] = StorageType.ARCHIVE;
        }
        this.addNodeByTypes(types);
        Thread.sleep(1000L);
        this.printMemUsage("before test1");
        this.totalStart = System.nanoTime();
        this.totalTrials = 0;
        for (i = 0; i < 20000; ++i) {
            this.localStart = System.nanoTime();
            while (true) {
                ++this.totalTrials;
                this.node = cluster.chooseRandom("", this.excluded);
                Assert.assertNotNull((Object)this.node);
                if (this.isType(this.node, StorageType.ARCHIVE)) break;
                this.excluded.add(this.node);
            }
            this.excluded.clear();
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {} avg trials: {}", new Object[]{Float.valueOf(this.totalMs), Float.valueOf(this.totalMs / 20000.0f), Float.valueOf((float)this.totalTrials / 20000.0f)});
        Thread.sleep(1000L);
        this.printMemUsage("after test1 before test2");
        this.totalStart = System.nanoTime();
        for (i = 0; i < 20000; ++i) {
            this.localStart = System.nanoTime();
            this.node = dfscluster.chooseRandomWithStorageType("", this.excluded, StorageType.ARCHIVE);
            Assert.assertNotNull((Object)this.node);
            Assert.assertTrue((boolean)this.isType(this.node, StorageType.ARCHIVE));
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {}", (Object)Float.valueOf(this.totalMs), (Object)Float.valueOf(this.totalMs / 20000.0f));
        this.printMemUsage("after test2");
    }

    @Test
    public void testSameStorageType() throws Exception {
        int i;
        for (i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.types[i] = StorageType.DISK;
        }
        this.addNodeByTypes(types);
        Thread.sleep(1000L);
        this.printMemUsage("before test1");
        this.totalStart = System.nanoTime();
        this.totalTrials = 0;
        for (i = 0; i < 20000; ++i) {
            while (true) {
                ++this.totalTrials;
                this.node = cluster.chooseRandom("", this.excluded);
                Assert.assertNotNull((Object)this.node);
                if (this.isType(this.node, StorageType.DISK)) break;
                this.excluded.add(this.node);
            }
            this.excluded.clear();
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {} avg trials: {}", new Object[]{Float.valueOf(this.totalMs), Float.valueOf(this.totalMs / 20000.0f), Float.valueOf((float)this.totalTrials / 20000.0f)});
        Thread.sleep(1000L);
        this.printMemUsage("after test1 before test2");
        this.totalStart = System.nanoTime();
        for (i = 0; i < 20000; ++i) {
            this.node = dfscluster.chooseRandomWithStorageType("", this.excluded, StorageType.DISK);
            Assert.assertNotNull((Object)this.node);
            Assert.assertTrue((boolean)this.isType(this.node, StorageType.DISK));
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {}", (Object)Float.valueOf(this.totalMs), (Object)Float.valueOf(this.totalMs / 20000.0f));
        this.printMemUsage("after test2");
    }

    private boolean coinFlip(double chance) {
        return (double)RANDOM.nextInt(2000) <= 2000.0 * chance;
    }

    @Test
    public void testPercentageStorageType() throws Exception {
        int i;
        double percentage = 0.9;
        for (i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.types[i] = this.coinFlip(percentage) ? StorageType.ARCHIVE : StorageType.DISK;
        }
        this.addNodeByTypes(types);
        Thread.sleep(1000L);
        this.printMemUsage("before test1");
        this.totalStart = System.nanoTime();
        this.totalTrials = 0;
        for (i = 0; i < 20000; ++i) {
            this.localStart = System.nanoTime();
            while (true) {
                ++this.totalTrials;
                this.node = cluster.chooseRandom("", this.excluded);
                Assert.assertNotNull((Object)this.node);
                if (this.isType(this.node, StorageType.ARCHIVE)) break;
                this.excluded.add(this.node);
            }
            this.excluded.clear();
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {} avg trials: {}", new Object[]{Float.valueOf(this.totalMs), Float.valueOf(this.totalMs / 20000.0f), Float.valueOf((float)this.totalTrials / 20000.0f)});
        Thread.sleep(1000L);
        this.printMemUsage("after test1 before test2");
        this.totalStart = System.nanoTime();
        for (i = 0; i < 20000; ++i) {
            this.localStart = System.nanoTime();
            this.node = dfscluster.chooseRandomWithStorageType("", this.excluded, StorageType.ARCHIVE);
            Assert.assertNotNull((Object)this.node);
            Assert.assertTrue((boolean)this.isType(this.node, StorageType.ARCHIVE));
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {}", (Object)Float.valueOf(this.totalMs), (Object)Float.valueOf(this.totalMs / 20000.0f));
        this.printMemUsage("after test2");
    }

    @Test
    public void testPercentageStorageTypeWithMixedTopology() throws Exception {
        int i;
        double percentage = 0.9;
        for (i = 0; i < 2000; ++i) {
            TestDFSNetworkTopologyPerformance.types[i] = this.coinFlip(percentage) ? StorageType.ARCHIVE : StorageType.DISK;
        }
        this.addNodeByTypes(types);
        Thread.sleep(1000L);
        this.printMemUsage("before test1");
        this.totalStart = System.nanoTime();
        this.totalTrials = 0;
        for (i = 0; i < 20000; ++i) {
            this.localStart = System.nanoTime();
            ++this.totalTrials;
            this.node = cluster.chooseRandom("", this.excluded);
            Assert.assertNotNull((Object)this.node);
            if (!this.isType(this.node, StorageType.ARCHIVE)) {
                ++this.totalTrials;
                this.excluded.add(this.node);
                this.node = dfscluster.chooseRandomWithStorageType("", this.excluded, StorageType.ARCHIVE);
            }
            Assert.assertTrue((boolean)this.isType(this.node, StorageType.ARCHIVE));
            this.excluded.clear();
            this.localEnd = System.nanoTime();
            TestDFSNetworkTopologyPerformance.records[i] = this.localEnd - this.localStart;
        }
        this.totalEnd = System.nanoTime();
        this.totalMs = (float)(this.totalEnd - this.totalStart) / 1000000.0f;
        LOG.info("total time: {} avg time: {} avg trials: {}", new Object[]{Float.valueOf(this.totalMs), Float.valueOf(this.totalMs / 20000.0f), Float.valueOf((float)this.totalTrials / 20000.0f)});
        Thread.sleep(1000L);
        this.printMemUsage("test StorageType with mixed topology.");
    }

    private void printMemUsage(String message) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("\nfree memory: " + format.format(freeMemory / 1024L));
        sb.append("\nallocated memory: " + format.format(allocatedMemory / 1024L));
        sb.append("\nmax memory: " + format.format(maxMemory / 1024L));
        sb.append("\ntotal free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
        LOG.info(sb.toString());
    }

    private void addNodeByTypes(StorageType[] allTypes) {
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(2000, racks, hosts, allTypes);
        this.dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        for (int i = 0; i < 2000; ++i) {
            cluster.add((Node)this.dataNodes[i]);
            dfscluster.add((Node)this.dataNodes[i]);
        }
    }

    private static String getRandLocation() {
        int l1 = RANDOM.nextInt(5) + 1;
        int l2 = RANDOM.nextInt(10) + 1;
        int l3 = RANDOM.nextInt(10) + 1;
        return String.format("/%d/%d/%d", l1, l2, l3);
    }

    private StorageType getRandType() {
        int len = StorageType.values().length;
        return StorageType.values()[RANDOM.nextInt(len)];
    }

    private boolean isType(Node n, StorageType type) {
        if (!(n instanceof DatanodeDescriptor)) {
            return false;
        }
        DatanodeDescriptor dnDescriptor = (DatanodeDescriptor)n;
        return dnDescriptor.hasStorageType(type);
    }

    static {
        RANDOM = new Random();
    }
}

