/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueResourceRoundingStrategy;

public class DefaultQueueResourceRoundingStrategy
implements QueueResourceRoundingStrategy {
    private final QueueCapacityVector.ResourceUnitCapacityType lastCapacityType;

    public DefaultQueueResourceRoundingStrategy(QueueCapacityVector.ResourceUnitCapacityType[] capacityTypePrecedence) {
        if (capacityTypePrecedence.length == 0) {
            throw new IllegalArgumentException("Capacity type precedence collection is empty");
        }
        this.lastCapacityType = capacityTypePrecedence[capacityTypePrecedence.length - 1];
    }

    @Override
    public double getRoundedResource(double resourceValue, QueueCapacityVector.QueueCapacityVectorEntry capacityVectorEntry) {
        if (capacityVectorEntry.getVectorResourceType().equals((Object)this.lastCapacityType)) {
            return Math.round(resourceValue);
        }
        return Math.floor(resourceValue);
    }
}

