/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Constants;
import org.apache.hadoop.fs.slive.Formatter;
import org.apache.hadoop.fs.slive.ObserveableOp;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationData;
import org.apache.hadoop.fs.slive.OperationFactory;
import org.apache.hadoop.fs.slive.OperationWeight;
import org.apache.hadoop.fs.slive.RouletteSelector;
import org.apache.hadoop.fs.slive.Weights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WeightSelector {
    private static final Logger LOG = LoggerFactory.getLogger(WeightSelector.class);
    private Map<Constants.OperationType, OperationInfo> operations;
    private Map<Constants.Distribution, Weightable> weights;
    private RouletteSelector selector;
    private OperationFactory factory;

    WeightSelector(ConfigExtractor cfg, Random rnd) {
        this.selector = new RouletteSelector(rnd);
        this.factory = new OperationFactory(cfg, rnd);
        this.configureOperations(cfg);
        this.configureWeights(cfg);
    }

    protected RouletteSelector getSelector() {
        return this.selector;
    }

    private void configureWeights(ConfigExtractor e) {
        this.weights = new HashMap<Constants.Distribution, Weightable>();
        this.weights.put(Constants.Distribution.UNIFORM, new Weights.UniformWeight());
    }

    static int determineHowMany(int totalAm, OperationData opData, Constants.OperationType type) {
        if (totalAm <= 0) {
            return 0;
        }
        int amLeft = (int)Math.floor(opData.getPercent() * (double)totalAm);
        if (amLeft < 0) {
            throw new IllegalArgumentException("Invalid amount " + amLeft + " determined for operation type " + type.name());
        }
        return amLeft;
    }

    private void configureOperations(ConfigExtractor cfg) {
        int totalAm;
        this.operations = new TreeMap<Constants.OperationType, OperationInfo>();
        Map<Constants.OperationType, OperationData> opinfo = cfg.getOperations();
        int opsLeft = totalAm = cfg.getOpCount().intValue();
        NumberFormat formatter = Formatter.getPercentFormatter();
        for (final Constants.OperationType type : opinfo.keySet()) {
            OperationData opData = opinfo.get((Object)type);
            OperationInfo info = new OperationInfo();
            info.distribution = opData.getDistribution();
            int amLeft = WeightSelector.determineHowMany(totalAm, opData, type);
            opsLeft -= amLeft;
            LOG.info(type.name() + " has " + amLeft + " initial operations out of " + totalAm + " for its ratio " + formatter.format(opData.getPercent()));
            info.amountLeft = amLeft;
            Operation op = this.factory.getOperation(type);
            if (op == null) continue;
            ObserveableOp.Observer fn = new ObserveableOp.Observer(){

                @Override
                public void notifyFinished(Operation op) {
                    OperationInfo opInfo = (OperationInfo)WeightSelector.this.operations.get((Object)type);
                    if (opInfo != null) {
                        OperationInfo operationInfo = opInfo;
                        operationInfo.amountLeft = operationInfo.amountLeft - 1;
                    }
                }

                @Override
                public void notifyStarting(Operation op) {
                }
            };
            info.operation = new ObserveableOp(op, fn);
            this.operations.put(type, info);
        }
        if (opsLeft > 0) {
            LOG.info(opsLeft + " left over operations found (due to inability to support partial operations)");
        }
    }

    Operation select(int elapsed, int duration) {
        ArrayList<OperationWeight> validOps = new ArrayList<OperationWeight>(this.operations.size());
        for (Constants.OperationType type : this.operations.keySet()) {
            OperationInfo opinfo = this.operations.get((Object)type);
            if (opinfo == null || opinfo.amountLeft <= 0) continue;
            Weightable weighter = this.weights.get((Object)opinfo.distribution);
            if (weighter != null) {
                OperationWeight weightOp = new OperationWeight(opinfo.operation, weighter.weight(elapsed, duration));
                validOps.add(weightOp);
                continue;
            }
            throw new RuntimeException("Unable to get weight for distribution " + (Object)((Object)opinfo.distribution));
        }
        if (validOps.isEmpty()) {
            return null;
        }
        return this.getSelector().select(validOps);
    }

    private static class OperationInfo {
        Integer amountLeft;
        Operation operation;
        Constants.Distribution distribution;

        private OperationInfo() {
        }
    }

    static interface Weightable {
        public Double weight(int var1, int var2);
    }
}

