/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientToAMTokenSelector
implements TokenSelector<ClientToAMTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientToAMTokenSelector.class);

    public Token<ClientToAMTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug("Looking for a token with service {}", (Object)service);
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Token kind is {} and the token's service name is {}", (Object)token.getKind(), (Object)token.getService());
            if (!ClientToAMTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            return token;
        }
        return null;
    }
}

