/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.util;

import java.util.Iterator;
import rx.Observable;
import rx.functions.Func2;

public final class MapWithIndex<T>
implements Observable.Transformer<T, Indexed<T>> {
    public static <T> MapWithIndex<T> instance() {
        return Holder.INSTANCE;
    }

    public Observable<Indexed<T>> call(Observable<T> source) {
        return source.zipWith((Iterable)NaturalNumbers.instance(), new Func2<T, Long, Indexed<T>>(){

            public Indexed<T> call(T t, Long n) {
                return new Indexed(t, n);
            }
        });
    }

    private static final class NaturalNumbers
    implements Iterable<Long> {
        private NaturalNumbers() {
        }

        static NaturalNumbers instance() {
            return Holder.INSTANCE;
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private long n = 0L;

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Long next() {
                    return this.n++;
                }

                @Override
                public void remove() {
                    throw new RuntimeException("not supported");
                }
            };
        }

        private static class Holder {
            static final NaturalNumbers INSTANCE = new NaturalNumbers();

            private Holder() {
            }
        }
    }

    public static final class Indexed<T> {
        private final long index;
        private final T value;

        public Indexed(T value, long index) {
            this.index = index;
            this.value = value;
        }

        public String toString() {
            return this.index + "->" + this.value;
        }

        public long index() {
            return this.index;
        }

        public T value() {
            return this.value;
        }
    }

    private static class Holder {
        static final MapWithIndex<?> INSTANCE = new MapWithIndex();

        private Holder() {
        }
    }
}

