/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class ForbiddenException
extends DocumentClientException {
    public ForbiddenException() {
        this("Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.");
    }

    public ForbiddenException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(403, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public ForbiddenException(String message) {
        this(message, null, (HttpResponseHeaders)null, null);
    }

    public ForbiddenException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public ForbiddenException(String message, HttpResponseHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    public ForbiddenException(Exception innerException) {
        this("Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.", innerException, null, null);
    }

    public ForbiddenException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 403, requestUri != null ? requestUri.toString() : null);
    }
}

