/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;

public class TestDelegatingSSLSocketFactory {
    @Test
    public void testOpenSSL() {
        Assume.assumeTrue((String)"Unable to load native libraries", (boolean)NativeCodeLoader.isNativeCodeLoaded());
        Assume.assumeTrue((String)"Build was not compiled with support for OpenSSL", (boolean)NativeCodeLoader.buildSupportsOpenssl());
        try {
            DelegatingSSLSocketFactory.initializeDefaultFactory((DelegatingSSLSocketFactory.SSLChannelMode)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
            Assertions.assertThat((String)DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()).contains(new CharSequence[]{"openssl"});
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)cause).describedAs("Cause of %s: %s", new Object[]{e, cause})).isInstanceOf(NoSuchAlgorithmException.class);
            Assume.assumeTrue((String)"wildfly library not compatible with this OS version", (boolean)false);
        }
    }

    @Test
    public void testJSEENoGCMJava8() throws IOException {
        Assume.assumeTrue((String)"Not running on Java 8", (boolean)System.getProperty("java.version").startsWith("1.8"));
        DelegatingSSLSocketFactory.initializeDefaultFactory((DelegatingSSLSocketFactory.SSLChannelMode)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        Assertions.assertThat(Arrays.stream(DelegatingSSLSocketFactory.getDefaultFactory().getSupportedCipherSuites())).noneMatch("GCM"::contains);
    }
}

