/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.cosn.CosNFileReadTask;
import org.apache.hadoop.fs.cosn.NativeFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNInputStream
extends FSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CosNInputStream.class);
    private FileSystem.Statistics statistics;
    private final Configuration conf;
    private final NativeFileSystemStore store;
    private final String key;
    private long position = 0L;
    private long nextPos = 0L;
    private long fileSize;
    private long partRemaining;
    private final long preReadPartSize;
    private final int maxReadPartNumber;
    private byte[] buffer;
    private boolean closed;
    private final ExecutorService readAheadExecutorService;
    private final Queue<ReadBuffer> readBufferQueue;

    public CosNInputStream(Configuration conf, NativeFileSystemStore store, FileSystem.Statistics statistics, String key, long fileSize, ExecutorService readAheadExecutorService) {
        this.conf = conf;
        this.store = store;
        this.statistics = statistics;
        this.key = key;
        this.fileSize = fileSize;
        this.preReadPartSize = conf.getLong("fs.cosn.read.ahead.block.size", 524288L);
        this.maxReadPartNumber = conf.getInt("fs.cosn.read.ahead.queue.size", 5);
        this.readAheadExecutorService = readAheadExecutorService;
        this.readBufferQueue = new ArrayDeque<ReadBuffer>(this.maxReadPartNumber);
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reopen(long pos) throws IOException {
        ReadBuffer readBuffer;
        long lastByteStart;
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (pos > this.fileSize) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        long partSize = pos + this.preReadPartSize > this.fileSize ? this.fileSize - pos : this.preReadPartSize;
        this.buffer = null;
        boolean isRandomIO = true;
        if (pos == this.nextPos) {
            isRandomIO = false;
        } else {
            while (this.readBufferQueue.size() != 0 && this.readBufferQueue.element().getStart() != pos) {
                this.readBufferQueue.poll();
            }
        }
        this.nextPos = pos + partSize;
        int currentBufferQueueSize = this.readBufferQueue.size();
        if (currentBufferQueueSize == 0) {
            lastByteStart = pos - partSize;
        } else {
            ReadBuffer[] readBuffers = this.readBufferQueue.toArray(new ReadBuffer[currentBufferQueueSize]);
            lastByteStart = readBuffers[currentBufferQueueSize - 1].getStart();
        }
        int maxLen = this.maxReadPartNumber - currentBufferQueueSize;
        for (int i = 0; i < maxLen && i < (currentBufferQueueSize + 1) * 2 && lastByteStart + partSize * (long)(i + 1) <= this.fileSize; ++i) {
            ReadBuffer readBuffer2;
            long byteStart = lastByteStart + partSize * (long)(i + 1);
            long byteEnd = byteStart + partSize - 1L;
            if (byteEnd >= this.fileSize) {
                byteEnd = this.fileSize - 1L;
            }
            if ((readBuffer2 = new ReadBuffer(byteStart, byteEnd)).getBuffer().length == 0) {
                readBuffer2.setStatus(0);
            } else {
                this.readAheadExecutorService.execute(new CosNFileReadTask(this.conf, this.key, this.store, readBuffer2));
            }
            this.readBufferQueue.add(readBuffer2);
            if (isRandomIO) break;
        }
        if (null != (readBuffer = this.readBufferQueue.poll())) {
            readBuffer.lock();
            try {
                readBuffer.await(1);
                this.buffer = (byte[])(readBuffer.getStatus() == -1 ? null : readBuffer.getBuffer());
            }
            catch (InterruptedException e) {
                LOG.warn("An interrupted exception occurred when waiting a read buffer.");
            }
            finally {
                readBuffer.unLock();
            }
        }
        if (null == this.buffer) {
            throw new IOException("Null IO stream");
        }
        this.position = pos;
        this.partRemaining = partSize;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (pos > this.fileSize) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        if (this.position == pos) {
            return;
        }
        if (pos > this.position && pos < this.position + this.partRemaining) {
            long len = pos - this.position;
            this.position = pos;
            this.partRemaining -= len;
        } else {
            this.reopen(pos);
        }
    }

    public long getPos() {
        return this.position;
    }

    public boolean seekToNewSource(long targetPos) {
        return false;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        if (this.partRemaining <= 0L && this.position < this.fileSize) {
            this.reopen(this.position);
        }
        int byteRead = -1;
        if (this.partRemaining != 0L) {
            byteRead = this.buffer[(int)((long)this.buffer.length - this.partRemaining)] & 0xFF;
        }
        if (byteRead >= 0) {
            ++this.position;
            --this.partRemaining;
            if (null != this.statistics) {
                this.statistics.incrementBytesRead((long)byteRead);
            }
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int bytesRead = 0;
        while (this.position < this.fileSize && bytesRead < len) {
            if (this.partRemaining <= 0L) {
                this.reopen(this.position);
            }
            int bytes = 0;
            for (int i = this.buffer.length - (int)this.partRemaining; i < this.buffer.length; ++i) {
                b[off + bytesRead] = this.buffer[i];
                ++bytes;
                if (off + ++bytesRead >= len) break;
            }
            if (bytes > 0) {
                this.position += (long)bytes;
                this.partRemaining -= (long)bytes;
                continue;
            }
            if (this.partRemaining == 0L) continue;
            throw new IOException("Failed to read from stream. Remaining: " + this.partRemaining);
        }
        if (null != this.statistics && bytesRead > 0) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead == 0 ? -1 : bytesRead;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        long remaining = this.fileSize - this.position;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.buffer = null;
    }

    public static class ReadBuffer {
        public static final int INIT = 1;
        public static final int SUCCESS = 0;
        public static final int ERROR = -1;
        private final ReentrantLock lock = new ReentrantLock();
        private Condition readyCondition = this.lock.newCondition();
        private byte[] buffer;
        private int status;
        private long start;
        private long end;

        public ReadBuffer(long start, long end) {
            this.start = start;
            this.end = end;
            this.buffer = new byte[(int)(this.end - this.start) + 1];
            this.status = 1;
        }

        public void lock() {
            this.lock.lock();
        }

        public void unLock() {
            this.lock.unlock();
        }

        public void await(int waitStatus) throws InterruptedException {
            while (this.status == waitStatus) {
                this.readyCondition.await();
            }
        }

        public void signalAll() {
            this.readyCondition.signalAll();
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

