/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.XDR;

public abstract class RpcMessage {
    protected final int xid;
    protected final Type messageType;

    RpcMessage(int xid, Type messageType) {
        if (messageType != Type.RPC_CALL && messageType != Type.RPC_REPLY) {
            throw new IllegalArgumentException("Invalid message type " + (Object)((Object)messageType));
        }
        this.xid = xid;
        this.messageType = messageType;
    }

    public abstract XDR write(XDR var1);

    public int getXid() {
        return this.xid;
    }

    public Type getMessageType() {
        return this.messageType;
    }

    protected void validateMessageType(Type expected) {
        if (expected != this.messageType) {
            throw new IllegalArgumentException("Message type is expected to be " + (Object)((Object)expected) + " but got " + (Object)((Object)this.messageType));
        }
    }

    public static enum Type {
        RPC_CALL,
        RPC_REPLY;


        public int getValue() {
            return this.ordinal();
        }

        public static Type fromValue(int value) {
            if (value < 0 || value >= Type.values().length) {
                return null;
            }
            return Type.values()[value];
        }
    }
}

