/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.ArrayList;
import java.util.List;

public interface IndexMapper<T extends Comparable<? super T>> {
    public static <T extends Comparable<? super T>> IndexMapper<T> make() {
        return new AnyIndex();
    }

    public long toIndex(T var1);

    public T toKey(long var1);

    public static final class AnyIndex<T extends Comparable<? super T>>
    implements IndexMapper<T> {
        private final List<T> myKeys = new ArrayList<T>();

        AnyIndex() {
        }

        @Override
        public synchronized long toIndex(T key) {
            long retVal = this.myKeys.indexOf(key);
            if (retVal < 0L) {
                retVal = this.myKeys.size();
                this.myKeys.add(key);
            }
            return retVal;
        }

        @Override
        public T toKey(long index) {
            return (T)((Comparable)this.myKeys.get((int)index));
        }
    }
}

