/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.LocalResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.OrderedResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestLocalResolver {
    @Test
    public void testLocalResolver() throws IOException {
        Configuration conf = new Configuration();
        Router router = (Router)Mockito.mock(Router.class);
        StateStoreService stateStore = (StateStoreService)Mockito.mock(StateStoreService.class);
        MembershipStore membership = (MembershipStore)Mockito.mock(MembershipStore.class);
        Mockito.when((Object)router.getStateStore()).thenReturn((Object)stateStore);
        Mockito.when((Object)stateStore.getRegisteredRecordStore((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)membership);
        GetNamenodeRegistrationsResponse response = GetNamenodeRegistrationsResponse.newInstance();
        LinkedList<MembershipState> records = new LinkedList<MembershipState>();
        records.add(this.newMembershipState("client0", "subcluster0"));
        records.add(this.newMembershipState("client1", "subcluster1"));
        records.add(this.newMembershipState("client2", "subcluster2"));
        response.setNamenodeMemberships(records);
        Mockito.when((Object)membership.getNamenodeRegistrations((GetNamenodeRegistrationsRequest)ArgumentMatchers.any(GetNamenodeRegistrationsRequest.class))).thenReturn((Object)response);
        StringBuilder sb = new StringBuilder("clientX");
        LocalResolver localResolver = new LocalResolver(conf, router);
        LocalResolver spyLocalResolver = (LocalResolver)Mockito.spy((Object)localResolver);
        ((LocalResolver)Mockito.doAnswer(invocation -> sb.toString()).when((Object)spyLocalResolver)).getClientAddr();
        MultipleDestinationMountTableResolver resolver = new MultipleDestinationMountTableResolver(conf, router);
        resolver.addResolver(DestinationOrder.LOCAL, (OrderedResolver)spyLocalResolver);
        HashMap<String, String> mapLocal = new HashMap<String, String>();
        mapLocal.put("subcluster0", "/local");
        mapLocal.put("subcluster1", "/local");
        mapLocal.put("subcluster2", "/local");
        MountTable localEntry = MountTable.newInstance((String)"/local", mapLocal);
        localEntry.setDestOrder(DestinationOrder.LOCAL);
        resolver.addEntry(localEntry);
        PathLocation dest = resolver.getDestinationForPath("/local/file0.txt");
        this.assertDestination("subcluster0", dest);
        TestLocalResolver.setClient(sb, "client2");
        dest = resolver.getDestinationForPath("/local/file0.txt");
        this.assertDestination("subcluster2", dest);
        TestLocalResolver.setClient(sb, "client1");
        dest = resolver.getDestinationForPath("/local/file0.txt");
        this.assertDestination("subcluster1", dest);
        TestLocalResolver.setClient(sb, "client0");
        dest = resolver.getDestinationForPath("/local/file0.txt");
        this.assertDestination("subcluster0", dest);
    }

    private void assertDestination(String expectedNsId, PathLocation loc) {
        List dests = loc.getDestinations();
        RemoteLocation dest = (RemoteLocation)dests.get(0);
        Assert.assertEquals((Object)expectedNsId, (Object)dest.getNameserviceId());
    }

    private MembershipState newMembershipState(String addr, String nsId) {
        return MembershipState.newInstance((String)"routerId", (String)nsId, (String)"nn0", (String)"cluster0", (String)"blockPool0", (String)(addr + ":8001"), (String)(addr + ":8002"), (String)(addr + ":8003"), (String)"http", (String)(addr + ":8004"), (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE, (boolean)false);
    }

    private static void setClient(StringBuilder sb, String client) {
        sb.replace(0, sb.length(), client);
    }
}

