/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.host;

import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRestrictionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostRestrictionParser.class);

    public static List<HostName> parseHostList(String hostString) {
        ArrayList<HostName> addressList = new ArrayList<HostName>();
        if (hostString == null || hostString.isEmpty()) {
            return addressList;
        }
        for (String host : hostString.split(";")) {
            HostName hostName = new HostName(host);
            try {
                hostName.validate();
                addressList.add(hostName);
            }
            catch (HostNameException e) {
                LOGGER.warn("Invalid host name or IP: {}", (Object)host);
                LOGGER.debug("HostNameException.", (Object)e.getMessage());
            }
        }
        return addressList;
    }
}

