/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.spm.domain.Question;
import org.apache.fineract.spm.domain.Response;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.util.SurveyApiConstants;
import org.springframework.stereotype.Component;

@Component
public class SurveyValidator {
    public void validate(Survey survey) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("survey");
        baseDataValidator.reset().parameter("key").value((Object)survey.getKey()).notNull().notBlank().notExceedingLengthOf(SurveyApiConstants.maxKeyLength);
        baseDataValidator.reset().parameter("name").value((Object)survey.getName()).notNull().notBlank().notExceedingLengthOf(SurveyApiConstants.maxNameLength);
        baseDataValidator.reset().parameter("countrycode").value((Object)survey.getCountryCode()).notNull().notBlank().notExceedingLengthOf(SurveyApiConstants.maxCountryCodeLength);
        baseDataValidator.reset().parameter("description").value((Object)survey.getDescription()).ignoreIfNull().notExceedingLengthOf(SurveyApiConstants.maxDescriptionLength);
        List questions = survey.getQuestions();
        baseDataValidator.reset().parameter("question").value((Object)questions).notNull();
        this.validateQuestions(baseDataValidator, questions);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateQuestions(DataValidatorBuilder baseDataValidator, List<Question> questions) {
        if (questions != null) {
            baseDataValidator.reset().parameter("question.length").value((Object)questions.toArray()).arrayNotEmpty();
            for (Question question : questions) {
                baseDataValidator.reset().parameter("question.key").value((Object)question.getKey()).notNull().notExceedingLengthOf(SurveyApiConstants.maxKeyLength);
                baseDataValidator.reset().parameter("question.text").value((Object)question.getText()).notNull().notExceedingLengthOf(SurveyApiConstants.maxTextLength);
                baseDataValidator.reset().parameter("question.description").value((Object)question.getDescription()).ignoreIfNull().notExceedingLengthOf(SurveyApiConstants.maxDescriptionLength);
                this.validateOptions(baseDataValidator, question);
            }
        }
    }

    private void validateOptions(DataValidatorBuilder baseDataValidator, Question question) {
        List responses = question.getResponses();
        baseDataValidator.reset().parameter("question.options").value((Object)responses).notNull();
        if (responses != null) {
            baseDataValidator.reset().parameter("question.options").value((Object)responses.toArray()).arrayNotEmpty();
            for (Response response : responses) {
                baseDataValidator.reset().parameter("options.text").value((Object)response.getText()).notNull().notExceedingLengthOf(SurveyApiConstants.maxTextLength);
                baseDataValidator.reset().parameter("options.value").value((Object)response.getValue()).notNull().notGreaterThanMax(SurveyApiConstants.maxOptionsValue);
            }
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

