/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.savings.api.SavingsAccountChargesApiResource;
import org.apache.fineract.portfolio.savings.api.SavingsAccountTransactionsApiResource;
import org.apache.fineract.portfolio.savings.api.SavingsAccountsApiResource;
import org.apache.fineract.portfolio.savings.api.SavingsApiSetConstants;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountNotFoundException;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.portfolio.self.savings.api.SelfSavingsApiResourceSwagger;
import org.apache.fineract.portfolio.self.savings.data.SelfSavingsDataValidator;
import org.apache.fineract.portfolio.self.savings.service.AppuserSavingsMapperReadService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/savingsaccounts")
@Component
@Tag(name="Self Savings Account", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class SelfSavingsApiResource {
    private final PlatformSecurityContext context;
    private final SavingsAccountsApiResource savingsAccountsApiResource;
    private final SavingsAccountChargesApiResource savingsAccountChargesApiResource;
    private final SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource;
    private final AppuserSavingsMapperReadService appuserSavingsMapperReadService;
    private final SelfSavingsDataValidator dataValidator;
    private final AppuserClientMapperReadService appUserClientMapperReadService;
    private final DefaultToApiJsonSerializer<SavingsAccountData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a savings account", description="Retrieves a savings account\n\nExample Requests :\n\nself/savingsaccounts/1\n\n\nself/savingsaccounts/1?associations=transactions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfSavingsApiResourceSwagger.GetSelfSavingsAccountsResponse.class))})})
    public String retrieveSavings(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @QueryParam(value="associations") @Parameter(description="associations") String associations, @Context UriInfo uriInfo) {
        this.dataValidator.validateRetrieveSavings(uriInfo);
        this.validateAppuserSavingsAccountMapping(accountId);
        boolean staffInSelectedOfficeOnly = false;
        SavingsAccountData result = this.savingsAccountsApiResource.retrieveOne(accountId, false, chargeStatus, associations, uriInfo);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)result, SavingsApiSetConstants.SAVINGS_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{accountId}/transactions/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Savings Account Transaction", description="Retrieves Savings Account Transaction\n\nExample Requests:\n\nself/savingsaccounts/1/transactions/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfSavingsApiResourceSwagger.GetSelfSavingsAccountsAccountIdTransactionsTransactionIdResponse.class))})})
    public String retrieveSavingsTransaction(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @PathParam(value="transactionId") @Parameter(description="transactionId") Long transactionId, @Context UriInfo uriInfo) {
        this.dataValidator.validateRetrieveSavingsTransaction(uriInfo);
        this.validateAppuserSavingsAccountMapping(accountId);
        return this.savingsAccountTransactionsApiResource.retrieveOne(accountId, transactionId, uriInfo);
    }

    @GET
    @Path(value="{accountId}/charges")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Savings Charges", description="Lists Savings Charges\n\nExample Requests:\n\nself/savingsaccounts/1/charges\n\nself/savingsaccounts/1/charges?chargeStatus=inactive\n\nself/savingsaccounts/1/charges?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfSavingsApiResourceSwagger.GetSelfSavingsAccountsAccountIdChargesResponse.class)))})})
    public String retrieveAllSavingsAccountCharges(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        this.validateAppuserSavingsAccountMapping(accountId);
        return this.savingsAccountChargesApiResource.retrieveAllSavingsAccountCharges(accountId, chargeStatus, uriInfo);
    }

    @GET
    @Path(value="{accountId}/charges/{savingsAccountChargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Savings account Charge", description="Retrieves a Savings account Charge\n\nExample Requests:\n\nself/savingsaccounts/1/charges/5\n\n\nself/savingsaccounts/1/charges/5?fields=name,amountOrPercentage")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfSavingsApiResourceSwagger.GetSelfSavingsAccountsAccountIdChargesSavingsAccountChargeIdResponse.class))})})
    public String retrieveSavingsAccountCharge(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @PathParam(value="savingsAccountChargeId") @Parameter(description="savingsAccountChargeId") Long savingsAccountChargeId, @Context UriInfo uriInfo) {
        this.validateAppuserSavingsAccountMapping(accountId);
        return this.savingsAccountChargesApiResource.retrieveSavingsAccountCharge(accountId, savingsAccountChargeId, uriInfo);
    }

    private void validateAppuserSavingsAccountMapping(Long accountId) {
        AppUser user = this.context.authenticatedUser();
        boolean isMappedSavings = this.appuserSavingsMapperReadService.isSavingsMappedToUser(accountId, (Long)user.getId());
        if (!isMappedSavings) {
            throw new SavingsAccountNotFoundException(accountId);
        }
    }

    @GET
    @Path(value="template")
    @Produces(value={"application/json"})
    public String template(@QueryParam(value="clientId") Long clientId, @QueryParam(value="productId") Long productId, @Context UriInfo uriInfo) {
        this.validateAppuserClientsMapping(clientId);
        Long groupId = null;
        boolean staffInSelectedOfficeOnly = false;
        return this.savingsAccountsApiResource.template(clientId, groupId, productId, staffInSelectedOfficeOnly, uriInfo);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String submitSavingsAccountApplication(@QueryParam(value="command") String commandParam, @Context UriInfo uriInfo, String apiRequestBodyAsJson) {
        HashMap parameterMap = this.dataValidator.validateSavingsApplication(apiRequestBodyAsJson);
        Long clientId = (Long)parameterMap.get("clientId");
        this.validateAppuserClientsMapping(clientId);
        return this.savingsAccountsApiResource.submitApplication(apiRequestBodyAsJson);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String modifySavingsAccountApplication(@PathParam(value="accountId") Long accountId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        this.validateAppuserSavingsAccountMapping(accountId);
        this.dataValidator.validateSavingsApplication(apiRequestBodyAsJson);
        return this.savingsAccountsApiResource.update(accountId, apiRequestBodyAsJson, commandParam);
    }

    private void validateAppuserClientsMapping(Long clientId) {
        AppUser user = this.context.authenticatedUser();
        boolean mappedClientId = this.appUserClientMapperReadService.isClientMappedToUser(clientId, (Long)user.getId());
        if (!mappedClientId) {
            throw new ClientNotFoundException(clientId);
        }
    }

    @Generated
    public SelfSavingsApiResource(PlatformSecurityContext context, SavingsAccountsApiResource savingsAccountsApiResource, SavingsAccountChargesApiResource savingsAccountChargesApiResource, SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource, AppuserSavingsMapperReadService appuserSavingsMapperReadService, SelfSavingsDataValidator dataValidator, AppuserClientMapperReadService appUserClientMapperReadService, DefaultToApiJsonSerializer<SavingsAccountData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.context = context;
        this.savingsAccountsApiResource = savingsAccountsApiResource;
        this.savingsAccountChargesApiResource = savingsAccountChargesApiResource;
        this.savingsAccountTransactionsApiResource = savingsAccountTransactionsApiResource;
        this.appuserSavingsMapperReadService = appuserSavingsMapperReadService;
        this.dataValidator = dataValidator;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

