/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.exception.ChargeCannotBeAppliedToException;
import org.apache.fineract.portfolio.client.data.ClientChargeDataValidator;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientCharge;
import org.apache.fineract.portfolio.client.domain.ClientChargePaidBy;
import org.apache.fineract.portfolio.client.domain.ClientChargeRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientTransaction;
import org.apache.fineract.portfolio.client.domain.ClientTransactionRepository;
import org.apache.fineract.portfolio.client.service.ClientChargeWritePlatformService;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;

@Service
public class ClientChargeWritePlatformServiceImpl
implements ClientChargeWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientChargeWritePlatformServiceImpl.class);
    private final ChargeRepositoryWrapper chargeRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final ClientChargeDataValidator clientChargeDataValidator;
    private final ConfigurationDomainService configurationDomainService;
    private final HolidayRepositoryWrapper holidayRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final ClientChargeRepositoryWrapper clientChargeRepository;
    private final ClientTransactionRepository clientTransactionRepository;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;

    public CommandProcessingResult addCharge(Long clientId, JsonCommand command) {
        try {
            this.clientChargeDataValidator.validateAdd(command.json());
            Client client = this.clientRepository.getActiveClientInUserScope(clientId);
            Long chargeDefinitionId = command.longValueOfParameterNamed("chargeId");
            Charge charge = this.chargeRepository.findOneWithNotFoundDetection(chargeDefinitionId);
            if (!charge.isClientCharge()) {
                String errorMessage = "Charge with identifier " + String.valueOf(charge.getId()) + " cannot be applied to a Client";
                throw new ChargeCannotBeAppliedToException("client", errorMessage, new Object[]{charge.getId()});
            }
            ClientCharge clientCharge = ClientCharge.createNew((Client)client, (Charge)charge, (JsonCommand)command);
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat());
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CLIENTCHARGE");
            LocalDate activationDate = client.getActivationDate();
            LocalDate dueDate = clientCharge.getDueLocalDate();
            if (DateUtils.isBefore((LocalDate)dueDate, (LocalDate)activationDate)) {
                baseDataValidator.reset().parameter("dueDate").value((Object)dueDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("dueDate.before.activationDate", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            this.validateDueDateOnWorkingDay(clientCharge, fmt);
            this.clientChargeRepository.saveAndFlush(clientCharge);
            return new CommandProcessingResultBuilder().withEntityId((Long)clientCharge.getId()).withOfficeId((Long)clientCharge.getClient().getOffice().getId()).withClientId((Long)clientCharge.getClient().getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(clientId, null, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult payCharge(Long clientId, Long clientChargeId, JsonCommand command) {
        try {
            this.clientChargeDataValidator.validatePayCharge(command.json());
            Client client = this.clientRepository.getActiveClientInUserScope(clientId);
            ClientCharge clientCharge = this.clientChargeRepository.findOneWithNotFoundDetection(clientChargeId);
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
            BigDecimal amountPaid = command.bigDecimalValueOfParameterNamed("amount");
            ExternalId transactionExternalId = ExternalIdFactory.produce((String)command.stringValueOfParameterNamedAllowingNull("externalId"));
            Money chargePaid = Money.of((MonetaryCurrency)clientCharge.getCurrency(), (BigDecimal)amountPaid);
            this.validatePaymentTransaction(client, clientCharge, fmt, transactionDate, amountPaid);
            clientCharge.pay(chargePaid);
            LinkedHashMap changes = new LinkedHashMap();
            PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
            ClientTransaction clientTransaction = ClientTransaction.payCharge((Client)client, (Office)client.getOffice(), (PaymentDetail)paymentDetail, (LocalDate)transactionDate, (Money)chargePaid, (String)clientCharge.getCurrency().getCode(), (ExternalId)transactionExternalId);
            this.clientTransactionRepository.saveAndFlush((Object)clientTransaction);
            ClientChargePaidBy chargePaidBy = ClientChargePaidBy.instance((ClientTransaction)clientTransaction, (ClientCharge)clientCharge, (BigDecimal)amountPaid);
            clientTransaction.getClientChargePaidByCollection().add(chargePaidBy);
            this.generateAccountingEntries(clientTransaction);
            return new CommandProcessingResultBuilder().withTransactionId(((Long)clientTransaction.getId()).toString()).withEntityId((Long)clientCharge.getId()).withSubEntityId((Long)clientTransaction.getId()).withSubEntityExternalId(clientTransaction.getExternalId()).withOfficeId((Long)clientCharge.getClient().getOffice().getId()).withClientId((Long)clientCharge.getClient().getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(clientId, clientChargeId, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void generateAccountingEntries(ClientTransaction clientTransaction) {
        Map accountingBridgeData = clientTransaction.toMapData();
        this.journalEntryWritePlatformService.createJournalEntriesForClientTransactions(accountingBridgeData);
    }

    public CommandProcessingResult waiveCharge(Long clientId, Long clientChargeId) {
        try {
            Client client = this.clientRepository.getActiveClientInUserScope(clientId);
            ClientCharge clientCharge = this.clientChargeRepository.findOneWithNotFoundDetection(clientChargeId);
            LocalDate transactionDate = DateUtils.getBusinessLocalDate();
            this.validateWaiverTransaction(client, clientCharge);
            Money waivedAmount = clientCharge.waive();
            ClientTransaction clientTransaction = ClientTransaction.waiver((Client)client, (Office)client.getOffice(), (LocalDate)transactionDate, (Money)waivedAmount, (String)clientCharge.getCurrency().getCode());
            this.clientTransactionRepository.saveAndFlush((Object)clientTransaction);
            ClientChargePaidBy chargePaidBy = ClientChargePaidBy.instance((ClientTransaction)clientTransaction, (ClientCharge)clientCharge, (BigDecimal)waivedAmount.getAmount());
            clientTransaction.getClientChargePaidByCollection().add(chargePaidBy);
            return new CommandProcessingResultBuilder().withTransactionId(((Long)clientTransaction.getId()).toString()).withEntityId((Long)clientCharge.getId()).withOfficeId((Long)clientCharge.getClient().getOffice().getId()).withClientId((Long)clientCharge.getClient().getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(clientId, clientChargeId, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult deleteCharge(Long clientId, Long clientChargeId) {
        try {
            Client client = this.clientRepository.getActiveClientInUserScope(clientId);
            ClientCharge clientCharge = this.clientChargeRepository.findOneWithNotFoundDetection(clientChargeId);
            this.validateChargeDeletion(client, clientCharge);
            this.clientChargeRepository.delete(clientCharge);
            return new CommandProcessingResultBuilder().withEntityId((Long)clientCharge.getId()).withOfficeId((Long)clientCharge.getClient().getOffice().getId()).withClientId((Long)clientCharge.getClient().getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleDataIntegrityIssues(clientId, clientChargeId, throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void validatePaymentDateAndAmount(Client client, ClientCharge clientCharge, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal amountPaid, boolean requiresTransactionDateValidation, boolean requiresTransactionAmountValidation) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CLIENTCHARGE");
        if (clientCharge.isNotActive()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("charge.is.not.active", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (requiresTransactionDateValidation) {
            this.validateTransactionDateOnWorkingDay(transactionDate, clientCharge, fmt);
            if (DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)client.getActivationDate())) {
                baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.before.activationDate", new Object[0]);
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
            if (DateUtils.isDateInTheFuture((LocalDate)transactionDate)) {
                baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.is.futureDate", new Object[0]);
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (clientCharge.isWaived()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("transaction.invalid.account.charge.is.already.waived", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        } else if (clientCharge.isPaid()) {
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("transaction.invalid.account.charge.is.paid", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (requiresTransactionAmountValidation) {
            Money chargePaid = Money.of((MonetaryCurrency)clientCharge.getCurrency(), (BigDecimal)amountPaid);
            if (!clientCharge.getAmountOutstanding().isGreaterThanOrEqualTo(chargePaid)) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("transaction.invalid.charge.amount.paid.in.access", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
        }
    }

    public void validateWaiverTransaction(Client client, ClientCharge clientCharge) {
        DateTimeFormatter fmt = null;
        LocalDate transactionDate = null;
        BigDecimal amountPaid = null;
        boolean requiresTransactionDateValidation = false;
        boolean requiresTransactionAmountValidation = false;
        this.validatePaymentDateAndAmount(client, clientCharge, fmt, transactionDate, amountPaid, requiresTransactionDateValidation, requiresTransactionAmountValidation);
    }

    public void validatePaymentTransaction(Client client, ClientCharge clientCharge, DateTimeFormatter fmt, LocalDate transactionDate, BigDecimal amountPaid) {
        boolean requiresTransactionDateValidation = true;
        boolean requiresTransactionAmountValidation = true;
        this.validatePaymentDateAndAmount(client, clientCharge, fmt, transactionDate, amountPaid, requiresTransactionDateValidation, requiresTransactionAmountValidation);
    }

    public void validateChargeDeletion(Client client, ClientCharge clientCharge) {
        DateTimeFormatter fmt = null;
        LocalDate transactionDate = null;
        BigDecimal amountPaid = null;
        boolean requiresTransactionDateValidation = false;
        boolean requiresTransactionAmountValidation = false;
        this.validatePaymentDateAndAmount(client, clientCharge, fmt, transactionDate, amountPaid, requiresTransactionDateValidation, requiresTransactionAmountValidation);
    }

    public CommandProcessingResult updateCharge(Long clientId, JsonCommand command) {
        return null;
    }

    public CommandProcessingResult inactivateCharge(Long clientId, Long clientChargeId) {
        return null;
    }

    private void validateDueDateOnWorkingDay(ClientCharge clientCharge, DateTimeFormatter fmt) {
        this.validateActivityDateFallOnAWorkingDay(clientCharge.getDueLocalDate(), clientCharge.getOfficeId(), "dueDate", "charge.due.date.is.on.holiday", "charge.due.date.is.a.non.workingday", fmt);
    }

    private void validateTransactionDateOnWorkingDay(LocalDate transactionDate, ClientCharge clientCharge, DateTimeFormatter fmt) {
        this.validateActivityDateFallOnAWorkingDay(transactionDate, clientCharge.getOfficeId(), "transactionDate", "transaction.not.allowed.transaction.date.is.on.holiday", "transaction.not.allowed.transaction.date.is.a.non.workingday", fmt);
    }

    private void validateActivityDateFallOnAWorkingDay(LocalDate date, Long officeId, String jsonPropertyName, String errorMessageFragmentForActivityOnHoliday, String errorMessageFragmentForActivityOnNonWorkingDay, DateTimeFormatter fmt) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CLIENTCHARGE");
        if (date != null) {
            if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(officeId, date)) {
                baseDataValidator.reset().parameter(jsonPropertyName).value((Object)date.format(fmt)).failWithCodeNoParameterAddedToErrorCode(errorMessageFragmentForActivityOnHoliday, new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(date)) {
                baseDataValidator.reset().parameter(jsonPropertyName).value((Object)date.format(fmt)).failWithCodeNoParameterAddedToErrorCode(errorMessageFragmentForActivityOnNonWorkingDay, new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
        }
    }

    private void handleDataIntegrityIssues(Long clientId, Long clientChargeId, Throwable realCause, NonTransientDataAccessException dve) {
        if (realCause.getMessage().contains("FK_m_client_charge_paid_by_m_client_charge")) {
            throw new PlatformDataIntegrityException("error.msg.client.charge.cannot.be.deleted", "Client charge with id `" + clientChargeId + "` cannot be deleted as transactions have been made on the same", "clientChargeId", new Object[]{clientChargeId});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.client.charges.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public ClientChargeWritePlatformServiceImpl(ChargeRepositoryWrapper chargeRepository, ClientRepositoryWrapper clientRepository, ClientChargeDataValidator clientChargeDataValidator, ConfigurationDomainService configurationDomainService, HolidayRepositoryWrapper holidayRepository, WorkingDaysRepositoryWrapper workingDaysRepository, ClientChargeRepositoryWrapper clientChargeRepository, ClientTransactionRepository clientTransactionRepository, PaymentDetailWritePlatformService paymentDetailWritePlatformService, JournalEntryWritePlatformService journalEntryWritePlatformService) {
        this.chargeRepository = chargeRepository;
        this.clientRepository = clientRepository;
        this.clientChargeDataValidator = clientChargeDataValidator;
        this.configurationDomainService = configurationDomainService;
        this.holidayRepository = holidayRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.clientChargeRepository = clientChargeRepository;
        this.clientTransactionRepository = clientTransactionRepository;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
    }
}

