/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.office.api;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.support.ExternalIdMapper;
import org.apache.fineract.organisation.office.api.OfficeSwaggerMapper;
import org.apache.fineract.organisation.office.api.OfficesApiResourceSwagger;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfficeSwaggerMapperImpl
implements OfficeSwaggerMapper {
    private final ExternalIdMapper externalIdMapper;

    @Autowired
    public OfficeSwaggerMapperImpl(ExternalIdMapper externalIdMapper) {
        this.externalIdMapper = externalIdMapper;
    }

    public OfficesApiResourceSwagger.PutOfficesOfficeIdResponse toPutOfficesOfficeIdResponse(CommandProcessingResult commandProcessingResult) {
        if (commandProcessingResult == null) {
            return null;
        }
        OfficesApiResourceSwagger.PutOfficesOfficeIdResponse putOfficesOfficeIdResponse = new OfficesApiResourceSwagger.PutOfficesOfficeIdResponse();
        putOfficesOfficeIdResponse.officeId = commandProcessingResult.getOfficeId();
        putOfficesOfficeIdResponse.resourceId = commandProcessingResult.getResourceId();
        if (commandProcessingResult.hasChanges()) {
            putOfficesOfficeIdResponse.changes = this.toPutOfficesOfficeIdResponseChanges(commandProcessingResult.getChanges());
        }
        return putOfficesOfficeIdResponse;
    }

    public OfficesApiResourceSwagger.GetOfficesResponse toGetOfficesResponse(OfficeData officeData) {
        if (officeData == null) {
            return null;
        }
        OfficesApiResourceSwagger.GetOfficesResponse getOfficesResponse = new OfficesApiResourceSwagger.GetOfficesResponse();
        getOfficesResponse.id = officeData.getId();
        getOfficesResponse.name = officeData.getName();
        getOfficesResponse.nameDecorated = officeData.getNameDecorated();
        getOfficesResponse.externalId = this.externalIdMapper.mapExternalId(officeData.getExternalId());
        getOfficesResponse.openingDate = officeData.getOpeningDate();
        getOfficesResponse.hierarchy = officeData.getHierarchy();
        getOfficesResponse.dateFormat = officeData.getDateFormat();
        getOfficesResponse.locale = officeData.getLocale();
        getOfficesResponse.allowedParents = this.officeDataCollectionToGetOfficesResponseCollection(officeData.getAllowedParents());
        return getOfficesResponse;
    }

    protected Collection<OfficesApiResourceSwagger.GetOfficesResponse> officeDataCollectionToGetOfficesResponseCollection(Collection<OfficeData> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<OfficesApiResourceSwagger.GetOfficesResponse> collection1 = new ArrayList<OfficesApiResourceSwagger.GetOfficesResponse>(collection.size());
        for (OfficeData officeData : collection) {
            collection1.add(this.toGetOfficesResponse(officeData));
        }
        return collection1;
    }
}

