/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.eventandlistener.NotificationEventPublisher;
import org.apache.fineract.notification.service.NotificationReadPlatformService;
import org.apache.fineract.notification.service.NotificationWritePlatformService;
import org.apache.fineract.notification.service.UserNotificationService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNotificationServiceImpl
implements UserNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserNotificationServiceImpl.class);
    private final NotificationEventPublisher notificationEventPublisher;
    private final AppUserRepository appUserRepository;
    private final FineractProperties fineractProperties;
    private final NotificationReadPlatformService notificationReadPlatformService;
    private final NotificationWritePlatformService notificationWritePlatformService;

    public void notifyUsers(String permission, String objectType, Long objectIdentifier, String notificationContent, String eventType, Long appUserId, Long officeId) {
        if (this.userNotificationSystemIsEnabled()) {
            String tenantIdentifier = ThreadLocalContextUtil.getTenant().getTenantIdentifier();
            Set userIds = this.getNotifiableUserIds(officeId, permission);
            NotificationData notificationData = new NotificationData().setObjectType(objectType).setObjectId(objectIdentifier).setAction(eventType).setActorId(appUserId).setContent(notificationContent).setRead(false).setSystemGenerated(false).setTenantIdentifier(tenantIdentifier).setOfficeId(officeId).setUserIds(userIds);
            try {
                this.notificationEventPublisher.broadcastNotification(notificationData);
            }
            catch (Exception e) {
                log.error("Error while broadcasting notification event", (Throwable)e);
            }
        }
    }

    public boolean hasUnreadUserNotifications(Long appUserId) {
        if (this.userNotificationSystemIsEnabled()) {
            return this.notificationReadPlatformService.hasUnreadNotifications(appUserId);
        }
        return false;
    }

    public void notifyUsers(NotificationData notificationData) {
        if (this.userNotificationSystemIsEnabled()) {
            Long appUserId = notificationData.getActorId();
            Set userIds = notificationData.getUserIds();
            if (notificationData.getOfficeId() != null) {
                ArrayList tempUserIds = new ArrayList(userIds);
                for (Long userId : tempUserIds) {
                    AppUser appUser = (AppUser)this.appUserRepository.findById((Object)userId).orElseThrow();
                    if (Objects.equals(appUser.getOffice().getId(), notificationData.getOfficeId())) continue;
                    userIds.remove(userId);
                }
            }
            if (userIds.contains(appUserId)) {
                userIds.remove(appUserId);
            }
            this.notificationWritePlatformService.notify((Collection)userIds, notificationData.getObjectType(), notificationData.getObjectId(), notificationData.getAction(), notificationData.getActorId(), notificationData.getContent(), notificationData.isSystemGenerated());
        }
    }

    private boolean userNotificationSystemIsEnabled() {
        return this.fineractProperties.getNotification().getUserNotificationSystem().isEnabled();
    }

    private Set<Long> getNotifiableUserIds(Long officeId, String permission) {
        Collection users = this.appUserRepository.findByOfficeId(officeId);
        List<AppUser> usersWithPermission = users.stream().filter(aU -> aU.hasAnyPermission(new String[]{permission, "ALL_FUNCTIONS"})).toList();
        return usersWithPermission.stream().map(AbstractPersistableCustom::getId).collect(Collectors.toSet());
    }

    @Generated
    public UserNotificationServiceImpl(NotificationEventPublisher notificationEventPublisher, AppUserRepository appUserRepository, FineractProperties fineractProperties, NotificationReadPlatformService notificationReadPlatformService, NotificationWritePlatformService notificationWritePlatformService) {
        this.notificationEventPublisher = notificationEventPublisher;
        this.appUserRepository = appUserRepository;
        this.fineractProperties = fineractProperties;
        this.notificationReadPlatformService = notificationReadPlatformService;
        this.notificationWritePlatformService = notificationWritePlatformService;
    }
}

