/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.eventmesh.common.config.connector.rdb.canal;

import org.apache.eventmesh.common.remote.job.SyncMode;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class CanalSinkIncrementConfig extends CanalSinkConfig {

    // batchSize
    private Integer batchSize = 50;

    // enable batch
    private Boolean useBatch = true;

    // sink thread size for single channel
    private Integer poolSize = 5;

    // sync mode: field/row
    private SyncMode syncMode = SyncMode.ROW;

    private boolean isGTIDMode = false;

    private boolean isMariaDB = true;

    // skip sink process exception
    private Boolean skipException = false;

    public SinkConnectorConfig sinkConnectorConfig;

}
