/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.codec.BaseEventCodec;

public class JCacheEventCodec
extends BaseEventCodec {
    private final boolean sync;
    private final boolean expectOldValueInMsg;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            Object key = JCacheEventCodec.this.decode(buf, state, JCacheEventCodec.this.codec.getMapKeyDecoder());
            result.add(key);
            Object value = JCacheEventCodec.this.decode(buf, state, JCacheEventCodec.this.codec.getMapValueDecoder());
            result.add(value);
            if (JCacheEventCodec.this.expectOldValueInMsg) {
                if (buf.getShortLE(buf.readerIndex()) != -1) {
                    Object oldValue = JCacheEventCodec.this.decode(buf, state, JCacheEventCodec.this.codec.getMapValueDecoder());
                    result.add(oldValue);
                } else {
                    buf.readShortLE();
                    result.add(null);
                }
            }
            if (JCacheEventCodec.this.sync) {
                double syncId = buf.readDoubleLE();
                result.add(syncId);
            }
            return result;
        }
    };

    public JCacheEventCodec(Codec codec, BaseEventCodec.OSType osType, boolean sync) {
        super(codec, osType);
        this.sync = sync;
        this.expectOldValueInMsg = false;
    }

    public JCacheEventCodec(Codec codec, BaseEventCodec.OSType osType, boolean sync, boolean expectOldValueInMsg) {
        super(codec, osType);
        this.sync = sync;
        this.expectOldValueInMsg = expectOldValueInMsg;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }
}

