/*
 * Decompiled with CFR 0.152.
 */
package jodd.time;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

@Deprecated
public class JulianDate
implements Serializable,
Cloneable {
    public static final JulianDate JD_1970 = new JulianDate(2440587, 0.5);
    public static final JulianDate JD_2001 = new JulianDate(2451910, 0.5);
    private static final JulianDate JD_RJD_0 = new JulianDate(2400000, 0.0);
    private static final JulianDate JD_MJD_0 = new JulianDate(2400000, 0.5);
    private static final JulianDate JD_TJD_0 = new JulianDate(2440000, 0.5);
    protected int integer;
    protected double fraction;

    public static JulianDate of(double jd) {
        int integer = (int)jd;
        double fraction = jd - (double)integer;
        return JulianDate.of(integer, fraction);
    }

    public static JulianDate of(LocalDateTime localDateTime) {
        return JulianDate.of(localDateTime.getYear(), localDateTime.getMonth().getValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000);
    }

    public static JulianDate of(LocalDate localDate) {
        return JulianDate.of(localDate.getYear(), localDate.getMonth().getValue(), localDate.getDayOfMonth(), 0, 0, 0, 0);
    }

    public static JulianDate of(Instant instant) {
        return JulianDate.of(instant.atZone(ZoneOffset.UTC).toLocalDateTime());
    }

    public static JulianDate of(long milliseconds) {
        return JulianDate.of(Instant.ofEpochMilli(milliseconds));
    }

    public static JulianDate of(int i, double f) {
        return new JulianDate(i, f);
    }

    public static JulianDate of(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        int im0;
        int iy0;
        double frac;
        if (month > 12 || month < -12) {
            int delta = --month / 12;
            year += delta;
            month -= delta * 12;
            ++month;
        }
        if (month < 0) {
            --year;
            month += 12;
        }
        if ((frac = (double)hour / 24.0 + (double)minute / 1440.0 + (double)second / 86400.0 + (double)millisecond / 8.64E7) < 0.0) {
            int delta = (int)(-frac) + 1;
            frac += (double)delta;
            day -= delta;
        }
        double gyr = (double)year + 0.01 * (double)month + 1.0E-4 * ((double)day + frac) + 1.0E-9;
        if (month <= 2) {
            iy0 = year - 1;
            im0 = month + 12;
        } else {
            iy0 = year;
            im0 = month;
        }
        int ia = iy0 / 100;
        int ib = 2 - ia + (ia >> 2);
        int jd = year <= 0 ? (int)(365.25 * (double)iy0 - 0.75) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994 : (int)(365.25 * (double)iy0) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994;
        if (gyr >= 1582.1015) {
            jd += ib;
        }
        return JulianDate.of(jd, frac + 0.5);
    }

    public static JulianDate of(BigDecimal bd) {
        double d = bd.doubleValue();
        int integer = (int)d;
        double fraction = bd.subtract(new BigDecimal(integer)).doubleValue();
        return JulianDate.of(integer, fraction);
    }

    public static JulianDate now() {
        return JulianDate.of(Instant.now());
    }

    public int getInteger() {
        return this.integer;
    }

    public double getFraction() {
        return this.fraction;
    }

    public int getSignificantFraction() {
        return (int)(this.fraction * 1.0E8);
    }

    public int getJulianDayNumber() {
        if (this.fraction >= 0.5) {
            return this.integer + 1;
        }
        return this.integer;
    }

    public JulianDate(int i, double f) {
        this.integer = i;
        this.fraction = f;
        int fi = (int)this.fraction;
        this.fraction -= (double)fi;
        this.integer += fi;
        if (this.fraction < 0.0) {
            this.fraction += 1.0;
            --this.integer;
        }
    }

    public double toDouble() {
        return (double)this.integer + this.fraction;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.integer).add(new BigDecimal(this.fraction));
    }

    public String toString() {
        String s = Double.toString(this.fraction);
        int i = s.indexOf(46);
        s = s.substring(i);
        return this.integer + s;
    }

    public long toMilliseconds() {
        return this.toInstant().toEpochMilli();
    }

    public Instant toInstant() {
        return this.toLocalDateTime().toInstant(ZoneOffset.UTC);
    }

    public LocalDateTime toLocalDateTime() {
        int ka = (int)(this.fraction + 0.5);
        int jd = this.integer + ka;
        double frac = this.fraction + 0.5 - (double)ka;
        ka = jd;
        if (jd >= 2299161) {
            int ialp = (int)(((double)jd - 1867216.25) / 36524.25);
            ka = jd + 1 + ialp - (ialp >> 2);
        }
        int kb = ka + 1524;
        int kc = (int)(((double)kb - 122.1) / 365.25);
        int kd = (int)((double)kc * 365.25);
        int ke = (int)((double)(kb - kd) / 30.6001);
        int day = kb - kd - (int)((double)ke * 30.6001);
        int month = ke > 13 ? ke - 13 : ke - 1;
        if (month == 2 && day > 28) {
            day = 29;
        }
        int year = month == 2 && day == 29 && ke == 3 ? kc - 4716 : (month > 2 ? kc - 4716 : kc - 4715);
        int time_year = year;
        int time_month = month;
        int time_day = day;
        double d_hour = frac * 24.0;
        int time_hour = (int)d_hour;
        double d_minute = (d_hour - (double)time_hour) * 60.0;
        int time_minute = (int)d_minute;
        double d_second = (d_minute - (double)time_minute) * 60.0;
        int time_second = (int)d_second;
        double d_millis = (d_second - (double)time_second) * 1000.0;
        int time_millisecond = (int)Math.round(d_millis);
        return LocalDateTime.of(time_year, time_month, time_day, time_hour, time_minute, time_second).plusNanos((long)time_millisecond * 1000000L);
    }

    public JulianDate add(JulianDate jds) {
        int i = this.integer + jds.integer;
        double f = this.fraction + jds.fraction;
        return new JulianDate(i, f);
    }

    public JulianDate add(double delta) {
        return this.add(JulianDate.of(delta));
    }

    public JulianDate sub(JulianDate jds) {
        int i = this.integer - jds.integer;
        double f = this.fraction - jds.fraction;
        return new JulianDate(i, f);
    }

    public JulianDate sub(double delta) {
        return this.sub(JulianDate.of(delta));
    }

    public int daysBetween(JulianDate otherDate) {
        return Math.abs(this.daysSpan(otherDate));
    }

    public int daysSpan(JulianDate otherDate) {
        int now = this.getJulianDayNumber();
        int then = otherDate.getJulianDayNumber();
        return now - then;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JulianDate stamp = (JulianDate)object;
        return stamp.integer == this.integer && Double.compare(stamp.fraction, this.fraction) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.integer, this.fraction);
    }

    protected JulianDate clone() {
        return new JulianDate(this.integer, this.fraction);
    }

    public JulianDate getReducedJulianDate() {
        return this.sub(JD_RJD_0);
    }

    public JulianDate getModifiedJulianDate() {
        return this.sub(JD_MJD_0);
    }

    public JulianDate getTruncatedJulianDate() {
        return this.sub(JD_TJD_0);
    }

    public static JulianDate fromReducedJulianDate(double rjd) {
        return JD_RJD_0.add(rjd);
    }

    public static JulianDate fromModifiedJulianDate(double mjd) {
        return JD_MJD_0.add(mjd);
    }

    public static JulianDate fromTruncatedJulianDate(double tjd) {
        return JD_TJD_0.add(tjd);
    }
}

