/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.AndMatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.MatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.NotMatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.OrMatcherOperator;
import java.util.ArrayList;
import java.util.List;

public class TransformerMatcherExecutionPlanner {
    public List<MatcherOperand> findIndex(MatcherOperand operand) {
        ArrayList<MatcherOperand> index = new ArrayList<MatcherOperand>();
        this.traversal(operand, index);
        return index;
    }

    private boolean traversal(MatcherOperand operand, List<MatcherOperand> index) {
        if (!operand.isOperator()) {
            if (operand.isIndex()) {
                index.add(operand);
                return true;
            }
            return false;
        }
        if (operand instanceof NotMatcherOperator) {
            return false;
        }
        MatcherOperator operator = (MatcherOperator)operand;
        MatcherOperand leftOperand = operator.getLeftOperand();
        if (leftOperand == null) {
            throw new IllegalArgumentException("invalid left operand - left operand must not be null. operator=" + operator);
        }
        MatcherOperand rightOperand = operator.getRightOperand();
        if (rightOperand == null) {
            throw new IllegalArgumentException("invalid right operand - right operand must not be null. operator=" + operator);
        }
        if (operand instanceof AndMatcherOperator) {
            boolean indexed = this.traversal(leftOperand, index);
            if (indexed) {
                return true;
            }
            return this.traversal(rightOperand, index);
        }
        if (operand instanceof OrMatcherOperator) {
            boolean indexed = this.traversal(leftOperand, index);
            return this.traversal(rightOperand, index) || indexed;
        }
        throw new IllegalArgumentException("unknown operator. operator=" + operand);
    }
}

