/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.MethodInsnNode;

public class ASMMethodInsnNodeRemapper {
    private final Filter[] filters;
    private final String owner;
    private final String name;
    private final String desc;

    private ASMMethodInsnNodeRemapper(Filter[] filters, String owner, String name, String desc) {
        this.filters = filters;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    private String mapOwner(String ownerClassInternalName) {
        return StringUtils.defaultString((String)this.owner, (String)ownerClassInternalName);
    }

    private String mapName(String name) {
        return StringUtils.defaultString((String)this.name, (String)name);
    }

    private String mapDesc(String desc) {
        return StringUtils.defaultString((String)this.desc, (String)desc);
    }

    public void mapping(MethodInsnNode methodInsnNode) {
        for (Filter filter : this.filters) {
            if (!filter.accept(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)) continue;
            methodInsnNode.owner = this.mapOwner(methodInsnNode.owner);
            methodInsnNode.name = this.mapName(methodInsnNode.name);
            methodInsnNode.desc = this.mapDesc(methodInsnNode.desc);
        }
    }

    private static class Filter {
        private final String owner;
        private final String name;
        private final String desc;

        public Filter(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public boolean accept(String owner, String name, String desc) {
            if (this.owner != null && !this.owner.equals(owner)) {
                return false;
            }
            if (this.name != null && !this.name.equals(name)) {
                return false;
            }
            return this.desc == null || this.desc.equals(desc);
        }
    }

    public static class Builder {
        private final List<Filter> filters = new ArrayList<Filter>();
        private String owner;
        private String name;
        private String desc;

        public void addFilter(String ownerClassInternalName, String name, String desc) {
            this.filters.add(new Filter(ownerClassInternalName, name, desc));
        }

        public void setOwner(String ownerClassInternalName) {
            this.owner = ownerClassInternalName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public ASMMethodInsnNodeRemapper build() {
            Filter[] copyFilter = this.filters.toArray(new Filter[0]);
            return new ASMMethodInsnNodeRemapper(copyFilter, this.owner, this.name, this.desc);
        }
    }
}

