/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metadata;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.cache.SimpleCache;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.provider.metadata.SimpleCacheFactory;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.DefaultApiMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import java.util.Objects;

public class ApiMetaDataServiceProvider
implements Provider<ApiMetaDataService> {
    private final Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> enhancedDataSenderProvider;
    private final SimpleCacheFactory simpleCacheFactory;

    @Inject
    public ApiMetaDataServiceProvider(@MetadataDataSender Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> enhancedDataSenderProvider, SimpleCacheFactory simpleCacheFactory) {
        this.enhancedDataSenderProvider = Objects.requireNonNull(enhancedDataSenderProvider, "enhancedDataSenderProvider");
        this.simpleCacheFactory = Objects.requireNonNull(simpleCacheFactory, "simpleCacheFactory");
    }

    public ApiMetaDataService get() {
        EnhancedDataSender enhancedDataSender = (EnhancedDataSender)this.enhancedDataSenderProvider.get();
        SimpleCache<String> simpleCache = this.simpleCacheFactory.newSimpleCache();
        return new DefaultApiMetaDataService((EnhancedDataSender<MetaDataType, ResponseMessage>)enhancedDataSender, simpleCache);
    }
}

