/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.UnaryCallDeadlineInterceptor;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.ClientRetryOption;
import com.navercorp.pinpoint.grpc.client.retry.HedgingServiceConfigBuilder;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.sender.grpc.MetadataGrpcDataSender;
import io.grpc.ClientInterceptor;
import io.grpc.NameResolverProvider;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataGrpcDataSenderProvider
implements Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GrpcTransportConfig grpcTransportConfig;
    private final MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter;
    private final HeaderFactory headerFactory;
    private final NameResolverProvider nameResolverProvider;
    private List<ClientInterceptor> clientInterceptorList;
    private final Provider<SslContext> sslContextProvider;

    @Inject
    public MetadataGrpcDataSenderProvider(GrpcTransportConfig grpcTransportConfig, @MetadataDataSender MessageConverter<MetaDataType, GeneratedMessageV3> messageConverter, HeaderFactory headerFactory, NameResolverProvider nameResolverProvider, Provider<SslContext> sslContextProvider) {
        this.grpcTransportConfig = Objects.requireNonNull(grpcTransportConfig, "grpcTransportConfig");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.headerFactory = Objects.requireNonNull(headerFactory, "headerFactory");
        this.nameResolverProvider = Objects.requireNonNull(nameResolverProvider, "nameResolverProvider");
        this.sslContextProvider = Objects.requireNonNull(sslContextProvider, "sslContextProvider");
    }

    @Inject(optional=true)
    public void setClientInterceptor(@MetadataDataSender List<ClientInterceptor> clientInterceptorList) {
        this.clientInterceptorList = Objects.requireNonNull(clientInterceptorList, "clientInterceptorList");
    }

    public EnhancedDataSender<MetaDataType, ResponseMessage> get() {
        String collectorIp = this.grpcTransportConfig.getMetadataCollectorIp();
        int collectorPort = this.grpcTransportConfig.getMetadataCollectorPort();
        boolean sslEnable = this.grpcTransportConfig.isMetadataSslEnable();
        int senderExecutorQueueSize = this.grpcTransportConfig.getMetadataSenderExecutorQueueSize();
        boolean clientRetryEnable = this.grpcTransportConfig.isMetadataRetryEnable();
        ChannelFactoryBuilder channelFactoryBuilder = this.newChannelFactoryBuilder(sslEnable, clientRetryEnable);
        ChannelFactory channelFactory = channelFactoryBuilder.build();
        int retryMaxCount = this.grpcTransportConfig.getMetadataRetryMaxCount();
        int retryDelayMillis = this.grpcTransportConfig.getMetadataRetryDelayMillis();
        return new MetadataGrpcDataSender<MetaDataType>(collectorIp, collectorPort, senderExecutorQueueSize, this.messageConverter, channelFactory, retryMaxCount, retryDelayMillis, clientRetryEnable);
    }

    protected ChannelFactoryBuilder newChannelFactoryBuilder(boolean sslEnable, boolean clientRetryEnable) {
        int channelExecutorQueueSize = this.grpcTransportConfig.getMetadataChannelExecutorQueueSize();
        UnaryCallDeadlineInterceptor unaryCallDeadlineInterceptor = new UnaryCallDeadlineInterceptor(this.grpcTransportConfig.getMetadataRequestTimeout());
        ClientOption clientOption = this.grpcTransportConfig.getMetadataClientOption();
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder("MetadataGrpcDataSender");
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        channelFactoryBuilder.addClientInterceptor((ClientInterceptor)unaryCallDeadlineInterceptor);
        if (this.clientInterceptorList != null) {
            for (ClientInterceptor clientInterceptor : this.clientInterceptorList) {
                this.logger.info("addClientInterceptor:{}", (Object)clientInterceptor);
                channelFactoryBuilder.addClientInterceptor(clientInterceptor);
            }
        }
        channelFactoryBuilder.setExecutorQueueSize(channelExecutorQueueSize);
        channelFactoryBuilder.setClientOption(clientOption);
        if (sslEnable) {
            SslContext sslContext = (SslContext)this.sslContextProvider.get();
            channelFactoryBuilder.setSslContext(sslContext);
        }
        if (clientRetryEnable) {
            HedgingServiceConfigBuilder hedgingServiceConfigBuilder = new HedgingServiceConfigBuilder();
            hedgingServiceConfigBuilder.setMaxAttempts(this.grpcTransportConfig.getMetadataMaxAttempts());
            hedgingServiceConfigBuilder.setHedgingDelayMillis(this.grpcTransportConfig.getMetadataHedgingDelayMillis());
            channelFactoryBuilder.setClientRetryOption(new ClientRetryOption(this.grpcTransportConfig.getMetadataRetryBufferSize(), this.grpcTransportConfig.getMetadataPerRpcBufferLimit(), hedgingServiceConfigBuilder.buildMetadataConfig()));
        }
        return channelFactoryBuilder;
    }
}

