/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.grpc.ExecutorUtils;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.module.AgentDataSender;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.module.ModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporter;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class GrpcModuleLifeCycle
implements ModuleLifeCycle {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> agentDataSenderProvider;
    private final Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> metadataDataSenderProvider;
    private final Provider<DataSender<SpanType>> spanDataSenderProvider;
    private final Provider<DataSender<MetricType>> statDataSenderProvider;
    private final Provider<ExecutorService> dnsExecutorServiceProvider;
    private final Provider<ScheduledExecutorService> reconnectScheduledExecutorProvider;
    private EnhancedDataSender<MetaDataType, ResponseMessage> agentDataSender;
    private EnhancedDataSender<MetaDataType, ResponseMessage> metadataDataSender;
    private DataSender<SpanType> spanDataSender;
    private DataSender<MetricType> statDataSender;
    private ExecutorService dnsExecutorService;
    private ScheduledExecutorService reconnectScheduledExecutorService;
    private final ChannelzScheduledReporter reporter;

    @Inject
    public GrpcModuleLifeCycle(@AgentDataSender Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> agentDataSenderProvider, @MetadataDataSender Provider<EnhancedDataSender<MetaDataType, ResponseMessage>> metadataDataSenderProvider, @SpanDataSender Provider<DataSender<SpanType>> spanDataSenderProvider, @StatDataSender Provider<DataSender<MetricType>> statDataSenderProvider, Provider<ExecutorService> dnsExecutorServiceProvider, Provider<ScheduledExecutorService> reconnectScheduledExecutorProvider, ChannelzScheduledReporter reporter) {
        this.agentDataSenderProvider = Objects.requireNonNull(agentDataSenderProvider, "agentDataSenderProvider");
        this.metadataDataSenderProvider = Objects.requireNonNull(metadataDataSenderProvider, "metadataDataSenderProvider");
        this.spanDataSenderProvider = Objects.requireNonNull(spanDataSenderProvider, "spanDataSenderProvider");
        this.statDataSenderProvider = Objects.requireNonNull(statDataSenderProvider, "statDataSenderProvider");
        this.dnsExecutorServiceProvider = Objects.requireNonNull(dnsExecutorServiceProvider, "dnsExecutorServiceProvider");
        this.reconnectScheduledExecutorProvider = Objects.requireNonNull(reconnectScheduledExecutorProvider, "reconnectScheduledExecutorProvider");
        this.reporter = Objects.requireNonNull(reporter, "reporter");
    }

    @Override
    public void start() {
        this.logger.info("start()");
        this.agentDataSender = (EnhancedDataSender)this.agentDataSenderProvider.get();
        this.logger.info("agetInfoDataSenderProvider:{}", this.agentDataSender);
        this.metadataDataSender = (EnhancedDataSender)this.metadataDataSenderProvider.get();
        this.logger.info("metadataDataSenderProvider:{}", this.metadataDataSender);
        this.spanDataSender = (DataSender)this.spanDataSenderProvider.get();
        this.logger.info("spanDataSenderProvider:{}", this.spanDataSender);
        this.statDataSender = (DataSender)this.statDataSenderProvider.get();
        this.logger.info("statDataSenderProvider:{}", this.statDataSender);
        this.dnsExecutorService = (ExecutorService)this.dnsExecutorServiceProvider.get();
        this.logger.info("dnsExecutorServiceProvider:{}", (Object)this.dnsExecutorService);
        this.reconnectScheduledExecutorService = (ScheduledExecutorService)this.reconnectScheduledExecutorProvider.get();
        this.logger.info("reconnectScheduledExecutorServiceProvider:{}", (Object)this.reconnectScheduledExecutorService);
    }

    @Override
    public void shutdown() {
        this.logger.info("shutdown()");
        if (this.spanDataSender != null) {
            this.spanDataSender.stop();
        }
        if (this.statDataSender != null) {
            this.statDataSender.stop();
        }
        if (this.agentDataSender != null) {
            this.agentDataSender.stop();
        }
        if (this.metadataDataSender != null) {
            this.metadataDataSender.stop();
        }
        if (this.dnsExecutorService != null) {
            ExecutorUtils.shutdownExecutorService((String)"dnsExecutor", (ExecutorService)this.dnsExecutorService);
        }
        if (this.reconnectScheduledExecutorService != null) {
            ExecutorUtils.shutdownExecutorService((String)"reconnectScheduledExecutor", (ExecutorService)this.reconnectScheduledExecutorService);
        }
        if (this.reporter != null) {
            this.reporter.stop();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GrpcModuleLifeCycle{");
        sb.append(", agentDataSender=").append(this.agentDataSender);
        sb.append(", metadataDataSender=").append(this.metadataDataSender);
        sb.append(", spanDataSender=").append(this.spanDataSender);
        sb.append(", statDataSender=").append(this.statDataSender);
        sb.append(", dnsExecutorService=").append(this.dnsExecutorService);
        sb.append(", reconnectScheduledExecutorService=" + this.reconnectScheduledExecutorService);
        sb.append('}');
        return sb.toString();
    }
}

