/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.AsyncDefaultTrace;
import com.navercorp.pinpoint.profiler.context.AsyncDisableTrace;
import com.navercorp.pinpoint.profiler.context.AsyncSpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.ChildTrace;
import com.navercorp.pinpoint.profiler.context.DefaultCloseListener;
import com.navercorp.pinpoint.profiler.context.DefaultSpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.DisableChildTrace;
import com.navercorp.pinpoint.profiler.context.DisableTrace;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanAsyncStateListener;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanFactory;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.id.ListenableAsyncState;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.LoggingAsyncState;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.recorder.DisableSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultBaseTraceFactory
implements BaseTraceFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final CallStackFactory<SpanEvent> callStackFactory;
    private final StorageFactory storageFactory;
    private final TraceSampler traceSampler;
    private final SpanFactory spanFactory;
    private final RecorderFactory recorderFactory;
    private final TraceRootFactory traceRootFactory;
    private final ActiveTraceRepository activeTraceRepository;
    private final UriStatStorage uriStatStorage;

    public DefaultBaseTraceFactory(TraceRootFactory traceRootFactory, CallStackFactory<SpanEvent> callStackFactory, StorageFactory storageFactory, TraceSampler traceSampler, SpanFactory spanFactory, RecorderFactory recorderFactory, ActiveTraceRepository activeTraceRepository, UriStatStorage uriStatStorage) {
        this.traceRootFactory = Objects.requireNonNull(traceRootFactory, "traceRootFactory");
        this.callStackFactory = Objects.requireNonNull(callStackFactory, "callStackFactory");
        this.storageFactory = Objects.requireNonNull(storageFactory, "storageFactory");
        this.traceSampler = Objects.requireNonNull(traceSampler, "traceSampler");
        this.spanFactory = Objects.requireNonNull(spanFactory, "spanFactory");
        this.recorderFactory = Objects.requireNonNull(recorderFactory, "recorderFactory");
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
        this.uriStatStorage = Objects.requireNonNull(uriStatStorage, "uriStatStorage");
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            return this.newDefaultTrace(traceRoot);
        }
        return this.newLocalTrace(state.nextId());
    }

    @Override
    public Trace newTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            return this.newDefaultTrace(traceRoot);
        }
        return this.newLocalTrace(state.nextId());
    }

    @Override
    public Trace newTraceObject(String urlPath) {
        TraceSampler.State state = this.traceSampler.isNewSampled(urlPath);
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            return this.newDefaultTrace(traceRoot);
        }
        return this.newLocalTrace(state.nextId());
    }

    @Override
    public Trace continueAsyncContextTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        AsyncSpanChunkFactory spanChunkFactory = new AsyncSpanChunkFactory(traceRoot, localAsyncId);
        Storage storage = this.storageFactory.createStorage(spanChunkFactory);
        CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
        SpanRecorder spanRecorder = this.recorderFactory.newTraceRootSpanRecorder(traceRoot);
        WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newChildTraceSpanEventRecorder(traceRoot);
        return new ChildTrace(traceRoot, callStack, storage, spanRecorder, wrappedSpanEventRecorder, localAsyncId);
    }

    @Override
    public Trace continueDisableAsyncContextTraceObject(LocalTraceRoot traceRoot) {
        AsyncState asyncState = this.newAsyncState(traceRoot, ActiveTraceHandle.EMPTY_HANDLE, ListenableAsyncState.AsyncStateListener.EMPTY);
        SpanRecorder spanRecorder = this.recorderFactory.newDisableSpanRecorder(traceRoot);
        DisableSpanEventRecorder spanEventRecorder = this.recorderFactory.newDisableChildTraceSpanEventRecorder(traceRoot, asyncState);
        return new DisableChildTrace(traceRoot, spanRecorder, spanEventRecorder);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            return this.newAsyncDefaultTrace(traceRoot);
        }
        return this.newAsyncLocalTrace(state.nextId());
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            return this.newAsyncDefaultTrace(traceRoot);
        }
        return this.newAsyncLocalTrace(state.nextId());
    }

    @Override
    public Trace newAsyncTraceObject(String urlPath) {
        TraceSampler.State state = this.traceSampler.isNewSampled(urlPath);
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            return this.newAsyncDefaultTrace(traceRoot);
        }
        return this.newAsyncLocalTrace(state.nextId());
    }

    @Override
    public Trace disableSampling() {
        TraceSampler.State state = this.traceSampler.getContinueDisableState();
        long nextContinuedDisabledId = state.nextId();
        return this.newLocalTrace(nextContinuedDisabledId);
    }

    private DefaultTrace newDefaultTrace(TraceRoot traceRoot) {
        Span span = this.spanFactory.newSpan(traceRoot);
        DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
        Storage storage = this.storageFactory.createStorage(spanChunkFactory);
        CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
        SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span);
        WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
        ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
        DefaultCloseListener closeListener = new DefaultCloseListener(traceRoot, handle, this.uriStatStorage);
        return new DefaultTrace(span, callStack, storage, spanRecorder, wrappedSpanEventRecorder, closeListener);
    }

    private AsyncDefaultTrace newAsyncDefaultTrace(TraceRoot traceRoot) {
        Span span = this.spanFactory.newSpan(traceRoot);
        DefaultSpanChunkFactory spanChunkFactory = new DefaultSpanChunkFactory(traceRoot);
        Storage storage = this.storageFactory.createStorage(spanChunkFactory);
        CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
        ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
        SpanAsyncStateListener asyncStateListener = new SpanAsyncStateListener(span, this.storageFactory);
        AsyncState asyncState = this.newAsyncState(traceRoot, handle, asyncStateListener);
        SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span);
        WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot, asyncState);
        return new AsyncDefaultTrace(span, callStack, storage, spanRecorder, wrappedSpanEventRecorder, asyncState);
    }

    private Trace newLocalTrace(long nextDisabledId) {
        LocalTraceRoot traceRoot = this.traceRootFactory.newDisableTraceRoot(nextDisabledId);
        SpanRecorder spanRecorder = this.recorderFactory.newDisableSpanRecorder(traceRoot);
        ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
        DefaultCloseListener closeListener = new DefaultCloseListener(traceRoot, handle, this.uriStatStorage);
        DisableSpanEventRecorder spanEventRecorder = this.recorderFactory.newDisableSpanEventRecorder(traceRoot);
        return new DisableTrace(traceRoot, spanRecorder, spanEventRecorder, closeListener);
    }

    private Trace newAsyncLocalTrace(long nextDisabledId) {
        LocalTraceRoot traceRoot = this.traceRootFactory.newDisableTraceRoot(nextDisabledId);
        SpanRecorder spanRecorder = this.recorderFactory.newDisableSpanRecorder(traceRoot);
        ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
        ListenableAsyncState.AsyncStateListener listener = ListenableAsyncState.AsyncStateListener.EMPTY;
        AsyncState asyncState = this.newAsyncState(traceRoot, handle, listener);
        DisableSpanEventRecorder spanEventRecorder = this.recorderFactory.newDisableSpanEventRecorder(traceRoot, asyncState);
        return new AsyncDisableTrace(traceRoot, spanRecorder, (SpanEventRecorder)spanEventRecorder, asyncState);
    }

    private AsyncState newAsyncState(LocalTraceRoot traceRoot, ActiveTraceHandle activeTrace, ListenableAsyncState.AsyncStateListener listener) {
        ListenableAsyncState listenableAsyncState = new ListenableAsyncState(traceRoot, listener, activeTrace, this.uriStatStorage);
        if (this.logger.isDebugEnabled()) {
            return new LoggingAsyncState(listenableAsyncState);
        }
        return listenableAsyncState;
    }

    private ActiveTraceHandle registerActiveTrace(TraceRoot traceRoot) {
        return this.activeTraceRepository.register(traceRoot);
    }

    private ActiveTraceHandle registerActiveTrace(LocalTraceRoot localTraceRoot) {
        return this.activeTraceRepository.register(localTraceRoot);
    }
}

