/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogContext;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import com.taobao.tddl.dbsync.binlog.event.RowsLogBuffer;
import com.taobao.tddl.dbsync.binlog.event.TableMapLogEvent;
import com.taobao.tddl.dbsync.binlog.exception.TableIdNotFoundException;
import java.nio.charset.Charset;
import java.util.BitSet;

public abstract class RowsLogEvent
extends LogEvent {
    private final long tableId;
    private TableMapLogEvent table;
    protected final int columnLen;
    protected final boolean partial;
    protected final BitSet columns;
    protected final BitSet changeColumns;
    protected int jsonColumnCount = 0;
    private final LogBuffer rowsBuf;
    private final int flags;
    public static final int STMT_END_F = 1;
    public static final int NO_FOREIGN_KEY_CHECKS_F = 2;
    public static final int RELAXED_UNIQUE_CHECKS_F = 4;
    public static final int COMPLETE_ROWS_F = 8;
    public static final int RW_MAPID_OFFSET = 0;
    public static final int RW_FLAGS_OFFSET = 6;
    public static final int RW_VHLEN_OFFSET = 8;
    public static final int RW_V_TAG_LEN = 1;
    public static final int RW_V_EXTRAINFO_TAG = 0;

    public RowsLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        this(header, buffer, descriptionEvent, false);
    }

    public RowsLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent, boolean partial) {
        this(header, buffer, descriptionEvent, false, false);
    }

    public RowsLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent, boolean partial, boolean compress) {
        super(header);
        int commonHeaderLen = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[header.type - 1];
        int headerLen = 0;
        buffer.position(commonHeaderLen + 0);
        this.tableId = postHeaderLen == 6 ? buffer.getUint32() : buffer.getUlong48();
        this.flags = buffer.getUint16();
        if (postHeaderLen == 10) {
            headerLen = buffer.getUint16();
            int start = buffer.position();
            int end = start + (headerLen -= 2);
            int i = start;
            block3: while (i < end) {
                switch (buffer.getUint8(i++)) {
                    case 0: {
                        buffer.position(i + 0);
                        int checkLen = buffer.getUint8();
                        int val = checkLen - 2;
                        assert (buffer.getUint8() == val);
                        for (int j = 0; j < val; ++j) {
                            assert (buffer.getUint8() == val);
                        }
                        continue block3;
                    }
                }
                i = end;
            }
        }
        buffer.position(commonHeaderLen + postHeaderLen + headerLen);
        this.columnLen = (int)buffer.getPackedLong();
        this.partial = partial;
        this.columns = buffer.getBitmap(this.columnLen);
        this.changeColumns = header.type == 24 || header.type == 31 || header.type == 39 || header.type == 170 || header.type == 167 ? buffer.getBitmap(this.columnLen) : this.columns;
        int dataSize = buffer.limit() - buffer.position();
        if (compress) {
            buffer = buffer.uncompressBuf();
            dataSize = buffer.limit();
            header.type = postHeaderLen == 10 ? header.type - 169 + 30 : header.type - 166 + 23;
        }
        this.rowsBuf = buffer.duplicate(dataSize);
    }

    public final void fillTable(LogContext context) {
        this.table = context.getTable(this.tableId);
        if (this.table == null) {
            throw new TableIdNotFoundException("not found tableId:" + this.tableId);
        }
        if ((this.flags & 1) != 0) {
            context.clearAllTables();
        }
        int jsonColumnCount = 0;
        int columnCnt = this.table.getColumnCnt();
        TableMapLogEvent.ColumnInfo[] columnInfo = this.table.getColumnInfo();
        for (int i = 0; i < columnCnt; ++i) {
            TableMapLogEvent.ColumnInfo info = columnInfo[i];
            if (info.type != 245) continue;
            ++jsonColumnCount;
        }
        this.jsonColumnCount = jsonColumnCount;
    }

    public final long getTableId() {
        return this.tableId;
    }

    public final TableMapLogEvent getTable() {
        return this.table;
    }

    public final BitSet getColumns() {
        return this.columns;
    }

    public final BitSet getChangeColumns() {
        return this.changeColumns;
    }

    public final RowsLogBuffer getRowsBuf(Charset charset) {
        return new RowsLogBuffer(this.rowsBuf, this.columnLen, charset, this.jsonColumnCount, this.partial);
    }

    public final int getFlags(int flags) {
        return this.flags & flags;
    }
}

