/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.pool;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.api.NodeType;
import org.redisson.client.FailedNodeDetector;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.ConnectionsHolder;
import org.redisson.connection.MasterSlaveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ConnectionPool<T extends RedisConnection> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Queue<ClientConnectionsEntry> entries = new ConcurrentLinkedQueue<ClientConnectionsEntry>();
    final ConnectionManager connectionManager;
    final MasterSlaveServersConfig config;
    final MasterSlaveEntry masterSlaveEntry;

    ConnectionPool(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry masterSlaveEntry) {
        this.config = config;
        this.masterSlaveEntry = masterSlaveEntry;
        this.connectionManager = connectionManager;
    }

    public final void addEntry(ClientConnectionsEntry entry) {
        this.entries.add(entry);
    }

    public final void removeEntry(ClientConnectionsEntry entry) {
        this.entries.remove(entry);
    }

    protected abstract ConnectionsHolder<T> getConnectionHolder(ClientConnectionsEntry var1, boolean var2);

    public CompletableFuture<T> get(RedisCommand<?> command, boolean trackChanges) {
        LinkedList<ClientConnectionsEntry> entriesCopy = new LinkedList<ClientConnectionsEntry>(this.entries);
        entriesCopy.removeIf(n -> n.isFreezed() || !this.isHealthy((ClientConnectionsEntry)n));
        if (!entriesCopy.isEmpty()) {
            ClientConnectionsEntry entry = this.config.getLoadBalancer().getEntry(entriesCopy, command);
            this.log.debug("Entry {} selected as connection source", (Object)entry);
            return this.acquireConnection(command, entry, trackChanges);
        }
        LinkedList<InetSocketAddress> failed = new LinkedList<InetSocketAddress>();
        LinkedList<InetSocketAddress> freezed = new LinkedList<InetSocketAddress>();
        for (ClientConnectionsEntry entry : this.entries) {
            if (entry.getClient().getConfig().getFailedNodeDetector().isNodeFailed()) {
                failed.add(entry.getClient().getAddr());
                continue;
            }
            if (!entry.isFreezed()) continue;
            freezed.add(entry.getClient().getAddr());
        }
        StringBuilder errorMsg = new StringBuilder(this.getClass().getSimpleName() + " no available Redis entries. Master entry host: " + this.masterSlaveEntry.getClient().getAddr() + " entries " + this.entries);
        if (!freezed.isEmpty()) {
            errorMsg.append(" Disconnected hosts: ").append(freezed);
        }
        if (!failed.isEmpty()) {
            errorMsg.append(" Hosts disconnected by 'failedNodeDetector:' ").append(failed);
        }
        RedisConnectionException exception = new RedisConnectionException(errorMsg.toString());
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    public CompletableFuture<T> get(RedisCommand<?> command, ClientConnectionsEntry entry, boolean trackChanges) {
        return this.acquireConnection(command, entry, trackChanges);
    }

    protected final CompletableFuture<T> acquireConnection(RedisCommand<?> command, ClientConnectionsEntry entry, boolean trackChanges) {
        ConnectionsHolder<T> handler = this.getConnectionHolder(entry, trackChanges);
        CompletableFuture<T> result = handler.acquireConnection(command);
        CompletableFuture cancelableFuture = new CompletableFuture();
        result.whenComplete((r, e) -> {
            if (e != null) {
                if (entry.getNodeType() == NodeType.SLAVE) {
                    FailedNodeDetector detector = entry.getClient().getConfig().getFailedNodeDetector();
                    detector.onConnectFailed();
                    if (detector.isNodeFailed()) {
                        this.log.error("Redis node {} has been marked as failed according to the detection logic defined in {}", (Object)entry.getClient().getAddr(), (Object)detector);
                        this.masterSlaveEntry.shutdownAndReconnectAsync(entry.getClient(), (Throwable)e);
                    }
                }
                cancelableFuture.completeExceptionally((Throwable)e);
                return;
            }
            entry.addHandler((RedisConnection)r, handler);
            if (entry.getNodeType() == NodeType.SLAVE) {
                entry.getClient().getConfig().getFailedNodeDetector().onConnectSuccessful();
            }
            if (!cancelableFuture.complete(r)) {
                entry.returnConnection(r);
            }
        });
        return cancelableFuture;
    }

    private boolean isHealthy(ClientConnectionsEntry entry) {
        return entry.getNodeType() != NodeType.SLAVE || !entry.getClient().getConfig().getFailedNodeDetector().isNodeFailed();
    }
}

