/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.pulsar.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.pulsar.config.ClientConfiguration;
import org.apache.eventmesh.storage.pulsar.producer.ProducerImpl;

@Config(field="clientConfiguration")
public class PulsarProducerImpl
implements Producer {
    private ProducerImpl producer;
    private ClientConfiguration clientConfiguration;

    public synchronized void init(Properties properties) {
        this.producer = new ProducerImpl(properties, this.clientConfiguration);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        this.producer.publish(cloudEvent, sendCallback);
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer.isClosed();
    }

    public void start() {
        this.producer.start();
    }

    public void shutdown() {
        this.producer.shutdown();
    }

    public void sendOneway(CloudEvent cloudEvent) {
        throw new StorageRuntimeException("SendOneWay is not supported");
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws Exception {
        throw new StorageRuntimeException("Request is not supported");
    }

    public boolean reply(CloudEvent cloudEvent, SendCallback sendCallback) throws Exception {
        throw new StorageRuntimeException("Reply is not supported");
    }

    public void checkTopicExist(String topic) throws Exception {
        throw new StorageRuntimeException("CheckTopicExist is not supported");
    }

    public void setExtFields() {
        throw new StorageRuntimeException("SetExtFields is not supported");
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }
}

