/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.io;

import com.alipay.hessian.generic.model.GenericClass;
import com.alipay.hessian.generic.util.ClassFilter;
import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.util.HashMap;

public class GenericClassDeserializer
extends AbstractDeserializer {
    private static final GenericClassDeserializer instance = new GenericClassDeserializer();
    private static final HashMap<String, Class> _primClasses = new HashMap();

    public static GenericClassDeserializer getInstance() {
        return instance;
    }

    private GenericClassDeserializer() {
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        int ref = in.addRef(null);
        String name = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            if ("name".equals(fieldNames[i])) {
                name = in.readString();
                continue;
            }
            in.readObject();
        }
        Object value = ClassFilter.filter(name) ? this.create(name) : new GenericClass(name);
        in.setRef(ref, value);
        return value;
    }

    Object create(String name) throws IOException {
        if (name == null) {
            throw new IOException("Serialized Class expects name.");
        }
        Class cl = _primClasses.get(name);
        if (cl != null) {
            return cl;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                return Class.forName(name, false, loader);
            }
            return Class.forName(name);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    static {
        _primClasses.put("void", Void.TYPE);
        _primClasses.put("boolean", Boolean.TYPE);
        _primClasses.put("java.lang.Boolean", Boolean.class);
        _primClasses.put("byte", Byte.TYPE);
        _primClasses.put("java.lang.Byte", Byte.class);
        _primClasses.put("char", Character.TYPE);
        _primClasses.put("java.lang.Character", Character.class);
        _primClasses.put("short", Short.TYPE);
        _primClasses.put("java.lang.Short", Short.class);
        _primClasses.put("int", Integer.TYPE);
        _primClasses.put("java.lang.Integer", Integer.class);
        _primClasses.put("long", Long.TYPE);
        _primClasses.put("java.lang.Long", Long.class);
        _primClasses.put("float", Float.TYPE);
        _primClasses.put("java.lang.Float", Float.class);
        _primClasses.put("double", Double.TYPE);
        _primClasses.put("java.lang.Double", Double.class);
        _primClasses.put("java.lang.String", String.class);
    }
}

