/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.chatgpt.source.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.connector.chatgpt.source.dto.ChatGPTRequestDTO;
import org.apache.eventmesh.connector.chatgpt.source.managers.OpenaiManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParseHandler.class);
    private final OpenaiManager openaiManager;
    private final String promptTemplate;
    private static final JsonFormat jsonFormat = new JsonFormat(false, true);

    public ParseHandler(OpenaiManager openaiManager, String promptTemplate) {
        this.openaiManager = openaiManager;
        this.promptTemplate = promptTemplate;
    }

    public CloudEvent invoke(ChatGPTRequestDTO event) {
        CloudEvent cloudEvent;
        Map<String, String> map = this.convertToMap(event);
        StringSubstitutor substitute = new StringSubstitutor(map);
        String finalPrompt = substitute.replace(this.promptTemplate);
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>();
        chatMessages.add(new ChatMessage(ChatMessageRole.USER.value(), finalPrompt));
        ChatCompletionRequest req = this.openaiManager.newChatCompletionRequest(chatMessages);
        String chatResult = this.openaiManager.getResult(req);
        chatResult = StringUtils.removeFirst((String)chatResult, (String)"```json");
        chatResult = StringUtils.removeEnd((String)chatResult, (String)"```");
        try {
            cloudEvent = jsonFormat.deserialize(chatResult.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            throw new IllegalStateException("cloudEvent parse fail, please check your parse prompt file content", e);
        }
        return cloudEvent;
    }

    public Map<String, String> convertToMap(Object obj) {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.isSynthetic() || Map.class.isAssignableFrom(field.getType()) || List.class.isAssignableFrom(field.getType())) continue;
            try {
                String key = field.getName();
                if (field.isAnnotationPresent(JsonProperty.class)) {
                    JsonProperty annotation = field.getAnnotation(JsonProperty.class);
                    key = annotation.value();
                }
                Method getter = this.getGetter(field, clazz);
                map.put(key, String.valueOf(getter.invoke(obj, new Object[0])));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("convert to Map is fail", e);
            }
        }
        return map;
    }

    public Method getGetter(Field field, Class<?> clazz) throws NoSuchMethodException {
        boolean isBooleanField = Boolean.TYPE.isAssignableFrom(field.getType()) || Boolean.class.isAssignableFrom(field.getType());
        String handledFieldName = this.upperFirst(field.getName());
        String methodName = isBooleanField ? "is" + handledFieldName : "get" + handledFieldName;
        return clazz.getDeclaredMethod(methodName, new Class[0]);
    }

    public String upperFirst(String str) {
        char firstChar;
        if (null == str) {
            return null;
        }
        if (!str.isEmpty() && Character.isLowerCase(firstChar = str.charAt(0))) {
            return Character.toUpperCase(firstChar) + StringUtils.substring((String)str, (int)1);
        }
        return str;
    }
}

