/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.client;

import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.assistants.Assistant;
import com.theokanning.openai.assistants.AssistantFile;
import com.theokanning.openai.assistants.AssistantFileRequest;
import com.theokanning.openai.assistants.AssistantRequest;
import com.theokanning.openai.assistants.ModifyAssistantRequest;
import com.theokanning.openai.audio.CreateSpeechRequest;
import com.theokanning.openai.audio.TranscriptionResult;
import com.theokanning.openai.audio.TranslationResult;
import com.theokanning.openai.billing.BillingUsage;
import com.theokanning.openai.billing.Subscription;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.engine.Engine;
import com.theokanning.openai.file.File;
import com.theokanning.openai.fine_tuning.FineTuningEvent;
import com.theokanning.openai.fine_tuning.FineTuningJob;
import com.theokanning.openai.fine_tuning.FineTuningJobRequest;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.messages.Message;
import com.theokanning.openai.messages.MessageFile;
import com.theokanning.openai.messages.MessageRequest;
import com.theokanning.openai.messages.ModifyMessageRequest;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import com.theokanning.openai.runs.CreateThreadAndRunRequest;
import com.theokanning.openai.runs.Run;
import com.theokanning.openai.runs.RunCreateRequest;
import com.theokanning.openai.runs.RunStep;
import com.theokanning.openai.runs.SubmitToolOutputsRequest;
import com.theokanning.openai.threads.Thread;
import com.theokanning.openai.threads.ThreadRequest;
import io.reactivex.Single;
import java.time.LocalDate;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Streaming;

public interface OpenAiApi {
    @GET(value="v1/models")
    public Single<OpenAiResponse<Model>> listModels();

    @GET(value="/v1/models/{model_id}")
    public Single<Model> getModel(@Path(value="model_id") String var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createCompletion(@Body CompletionRequest var1);

    @Streaming
    @POST(value="/v1/completions")
    public Call<ResponseBody> createCompletionStream(@Body CompletionRequest var1);

    @POST(value="/v1/chat/completions")
    public Single<ChatCompletionResult> createChatCompletion(@Body ChatCompletionRequest var1);

    @Streaming
    @POST(value="/v1/chat/completions")
    public Call<ResponseBody> createChatCompletionStream(@Body ChatCompletionRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/completions")
    public Single<CompletionResult> createCompletion(@Path(value="engine_id") String var1, @Body CompletionRequest var2);

    @POST(value="/v1/edits")
    public Single<EditResult> createEdit(@Body EditRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/edits")
    public Single<EditResult> createEdit(@Path(value="engine_id") String var1, @Body EditRequest var2);

    @POST(value="/v1/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body EmbeddingRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Path(value="engine_id") String var1, @Body EmbeddingRequest var2);

    @GET(value="/v1/files")
    public Single<OpenAiResponse<File>> listFiles();

    @Multipart
    @POST(value="/v1/files")
    public Single<File> uploadFile(@Part(value="purpose") RequestBody var1, @Part MultipartBody.Part var2);

    @DELETE(value="/v1/files/{file_id}")
    public Single<DeleteResult> deleteFile(@Path(value="file_id") String var1);

    @GET(value="/v1/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @Streaming
    @GET(value="/v1/files/{file_id}/content")
    public Single<ResponseBody> retrieveFileContent(@Path(value="file_id") String var1);

    @POST(value="/v1/fine_tuning/jobs")
    public Single<FineTuningJob> createFineTuningJob(@Body FineTuningJobRequest var1);

    @GET(value="/v1/fine_tuning/jobs")
    public Single<OpenAiResponse<FineTuningJob>> listFineTuningJobs();

    @GET(value="/v1/fine_tuning/jobs/{fine_tuning_job_id}")
    public Single<FineTuningJob> retrieveFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @POST(value="/v1/fine_tuning/jobs/{fine_tuning_job_id}/cancel")
    public Single<FineTuningJob> cancelFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @GET(value="/v1/fine_tuning/jobs/{fine_tuning_job_id}/events")
    public Single<OpenAiResponse<FineTuningEvent>> listFineTuningJobEvents(@Path(value="fine_tuning_job_id") String var1);

    @Deprecated
    @POST(value="/v1/fine-tunes")
    public Single<FineTuneResult> createFineTune(@Body FineTuneRequest var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createFineTuneCompletion(@Body CompletionRequest var1);

    @Deprecated
    @GET(value="/v1/fine-tunes")
    public Single<OpenAiResponse<FineTuneResult>> listFineTunes();

    @Deprecated
    @GET(value="/v1/fine-tunes/{fine_tune_id}")
    public Single<FineTuneResult> retrieveFineTune(@Path(value="fine_tune_id") String var1);

    @Deprecated
    @POST(value="/v1/fine-tunes/{fine_tune_id}/cancel")
    public Single<FineTuneResult> cancelFineTune(@Path(value="fine_tune_id") String var1);

    @Deprecated
    @GET(value="/v1/fine-tunes/{fine_tune_id}/events")
    public Single<OpenAiResponse<FineTuneEvent>> listFineTuneEvents(@Path(value="fine_tune_id") String var1);

    @DELETE(value="/v1/models/{fine_tune_id}")
    public Single<DeleteResult> deleteFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="/v1/images/generations")
    public Single<ImageResult> createImage(@Body CreateImageRequest var1);

    @POST(value="/v1/images/edits")
    public Single<ImageResult> createImageEdit(@Body RequestBody var1);

    @POST(value="/v1/images/variations")
    public Single<ImageResult> createImageVariation(@Body RequestBody var1);

    @POST(value="/v1/audio/transcriptions")
    public Single<TranscriptionResult> createTranscription(@Body RequestBody var1);

    @POST(value="/v1/audio/translations")
    public Single<TranslationResult> createTranslation(@Body RequestBody var1);

    @POST(value="/v1/audio/speech")
    public Single<ResponseBody> createSpeech(@Body CreateSpeechRequest var1);

    @POST(value="/v1/moderations")
    public Single<ModerationResult> createModeration(@Body ModerationRequest var1);

    @Deprecated
    @GET(value="v1/engines")
    public Single<OpenAiResponse<Engine>> getEngines();

    @Deprecated
    @GET(value="/v1/engines/{engine_id}")
    public Single<Engine> getEngine(@Path(value="engine_id") String var1);

    @Deprecated
    @GET(value="v1/dashboard/billing/subscription")
    public Single<Subscription> subscription();

    @Deprecated
    @GET(value="v1/dashboard/billing/usage")
    public Single<BillingUsage> billingUsage(@Query(value="start_date") LocalDate var1, @Query(value="end_date") LocalDate var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/assistants")
    public Single<Assistant> createAssistant(@Body AssistantRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/assistants/{assistant_id}")
    public Single<Assistant> retrieveAssistant(@Path(value="assistant_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/assistants/{assistant_id}")
    public Single<Assistant> modifyAssistant(@Path(value="assistant_id") String var1, @Body ModifyAssistantRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @DELETE(value="/v1/assistants/{assistant_id}")
    public Single<DeleteResult> deleteAssistant(@Path(value="assistant_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/assistants")
    public Single<OpenAiResponse<Assistant>> listAssistants(@QueryMap Map<String, Object> var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/assistants/{assistant_id}/files")
    public Single<AssistantFile> createAssistantFile(@Path(value="assistant_id") String var1, @Body AssistantFileRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/assistants/{assistant_id}/files/{file_id}")
    public Single<AssistantFile> retrieveAssistantFile(@Path(value="assistant_id") String var1, @Path(value="file_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @DELETE(value="/v1/assistants/{assistant_id}/files/{file_id}")
    public Single<DeleteResult> deleteAssistantFile(@Path(value="assistant_id") String var1, @Path(value="file_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/assistants/{assistant_id}/files")
    public Single<OpenAiResponse<Assistant>> listAssistantFiles(@Path(value="assistant_id") String var1, @QueryMap Map<String, Object> var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads")
    public Single<Thread> createThread(@Body ThreadRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}")
    public Single<Thread> retrieveThread(@Path(value="thread_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}")
    public Single<Thread> modifyThread(@Path(value="thread_id") String var1, @Body ThreadRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @DELETE(value="/v1/threads/{thread_id}")
    public Single<DeleteResult> deleteThread(@Path(value="thread_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/messages")
    public Single<Message> createMessage(@Path(value="thread_id") String var1, @Body MessageRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages/{message_id}")
    public Single<Message> retrieveMessage(@Path(value="thread_id") String var1, @Path(value="message_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/messages/{message_id}")
    public Single<Message> modifyMessage(@Path(value="thread_id") String var1, @Path(value="message_id") String var2, @Body ModifyMessageRequest var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages")
    public Single<OpenAiResponse<Message>> listMessages(@Path(value="thread_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages")
    public Single<OpenAiResponse<Message>> listMessages(@Path(value="thread_id") String var1, @QueryMap Map<String, Object> var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages/{message_id}/files/{file_id}")
    public Single<MessageFile> retrieveMessageFile(@Path(value="thread_id") String var1, @Path(value="message_id") String var2, @Path(value="file_id") String var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages/{message_id}/files")
    public Single<OpenAiResponse<MessageFile>> listMessageFiles(@Path(value="thread_id") String var1, @Path(value="message_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/messages/{message_id}/files")
    public Single<OpenAiResponse<MessageFile>> listMessageFiles(@Path(value="thread_id") String var1, @Path(value="message_id") String var2, @QueryMap Map<String, Object> var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/runs")
    public Single<Run> createRun(@Path(value="thread_id") String var1, @Body RunCreateRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/runs/{run_id}")
    public Single<Run> retrieveRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/runs/{run_id}")
    public Single<Run> modifyRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Body Map<String, String> var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/runs")
    public Single<OpenAiResponse<Run>> listRuns(@Path(value="thread_id") String var1, @QueryMap Map<String, String> var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/runs/{run_id}/submit_tool_outputs")
    public Single<Run> submitToolOutputs(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Body SubmitToolOutputsRequest var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/{thread_id}/runs/{run_id}/cancel")
    public Single<Run> cancelRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @POST(value="/v1/threads/runs")
    public Single<Run> createThreadAndRun(@Body CreateThreadAndRunRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/runs/{run_id}/steps/{step_id}")
    public Single<RunStep> retrieveRunStep(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Path(value="step_id") String var3);

    @Headers(value={"OpenAI-Beta: assistants=v1"})
    @GET(value="/v1/threads/{thread_id}/runs/{run_id}/steps")
    public Single<OpenAiResponse<RunStep>> listRunSteps(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @QueryMap Map<String, String> var3);
}

