/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.filter;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.MessageEvaluationContext;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.filter.expression.EvaluationContext;
import org.apache.rocketmq.filter.util.BitsArray;
import org.apache.rocketmq.filter.util.BloomFilter;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.MessageFilter;

public class ExpressionMessageFilter
implements MessageFilter {
    protected static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqFilter");
    protected final SubscriptionData subscriptionData;
    protected final ConsumerFilterData consumerFilterData;
    protected final ConsumerFilterManager consumerFilterManager;
    protected final boolean bloomDataValid;

    public ExpressionMessageFilter(SubscriptionData subscriptionData, ConsumerFilterData consumerFilterData, ConsumerFilterManager consumerFilterManager) {
        this.subscriptionData = subscriptionData;
        this.consumerFilterData = consumerFilterData;
        this.consumerFilterManager = consumerFilterManager;
        if (consumerFilterData == null) {
            this.bloomDataValid = false;
            return;
        }
        BloomFilter bloomFilter = this.consumerFilterManager.getBloomFilter();
        this.bloomDataValid = bloomFilter != null && bloomFilter.isValid(consumerFilterData.getBloomFilterData());
    }

    public boolean isMatchedByConsumeQueue(Long tagsCode, ConsumeQueueExt.CqExtUnit cqExtUnit) {
        if (null == this.subscriptionData) {
            return true;
        }
        if (this.subscriptionData.isClassFilterMode()) {
            return true;
        }
        if (ExpressionType.isTagType((String)this.subscriptionData.getExpressionType())) {
            if (tagsCode == null) {
                return true;
            }
            if (this.subscriptionData.getSubString().equals("*")) {
                return true;
            }
            return this.subscriptionData.getCodeSet().contains(tagsCode.intValue());
        }
        if (this.consumerFilterData == null || this.consumerFilterData.getExpression() == null || this.consumerFilterData.getCompiledExpression() == null || this.consumerFilterData.getBloomFilterData() == null) {
            return true;
        }
        if (cqExtUnit == null || !this.consumerFilterData.isMsgInLive(cqExtUnit.getMsgStoreTime())) {
            log.debug("Pull matched because not in live: {}, {}", (Object)this.consumerFilterData, (Object)cqExtUnit);
            return true;
        }
        byte[] filterBitMap = cqExtUnit.getFilterBitMap();
        BloomFilter bloomFilter = this.consumerFilterManager.getBloomFilter();
        if (filterBitMap == null || !this.bloomDataValid || filterBitMap.length * 8 != this.consumerFilterData.getBloomFilterData().getBitNum()) {
            return true;
        }
        BitsArray bitsArray = null;
        try {
            bitsArray = BitsArray.create((byte[])filterBitMap);
            boolean ret = bloomFilter.isHit(this.consumerFilterData.getBloomFilterData(), bitsArray);
            log.debug("Pull {} by bit map:{}, {}, {}", new Object[]{ret, this.consumerFilterData, bitsArray, cqExtUnit});
            return ret;
        }
        catch (Throwable e) {
            log.error("bloom filter error, sub=" + this.subscriptionData + ", filter=" + this.consumerFilterData + ", bitMap=" + bitsArray, e);
            return true;
        }
    }

    public boolean isMatchedByCommitLog(ByteBuffer msgBuffer, Map<String, String> properties) {
        if (this.subscriptionData == null) {
            return true;
        }
        if (this.subscriptionData.isClassFilterMode()) {
            return true;
        }
        if (ExpressionType.isTagType((String)this.subscriptionData.getExpressionType())) {
            return true;
        }
        ConsumerFilterData realFilterData = this.consumerFilterData;
        Map tempProperties = properties;
        if (realFilterData == null || realFilterData.getExpression() == null || realFilterData.getCompiledExpression() == null) {
            return true;
        }
        if (tempProperties == null && msgBuffer != null) {
            tempProperties = MessageDecoder.decodeProperties((ByteBuffer)msgBuffer);
        }
        Object ret = null;
        try {
            MessageEvaluationContext context = new MessageEvaluationContext(tempProperties);
            ret = realFilterData.getCompiledExpression().evaluate((EvaluationContext)context);
        }
        catch (Throwable e) {
            log.error("Message Filter error, " + realFilterData + ", " + tempProperties, e);
        }
        log.debug("Pull eval result: {}, {}, {}", new Object[]{ret, realFilterData, tempProperties});
        if (ret == null || !(ret instanceof Boolean)) {
            return false;
        }
        return (Boolean)ret;
    }
}

