/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.MethodType;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.provider.SessionCredentialsProvider;
import com.aliyun.credentials.utils.ParameterHelper;
import com.aliyun.credentials.utils.StringUtils;
import com.aliyun.tea.utils.Validate;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class URLCredentialProvider
extends SessionCredentialsProvider {
    private URL credentialsURI;
    private int connectTimeout = 1000;
    private int readTimeout = 1000;

    @Deprecated
    public URLCredentialProvider() {
        this(System.getenv("ALIBABA_CLOUD_CREDENTIALS_URI"));
    }

    @Deprecated
    public URLCredentialProvider(String credentialsURI) {
        super(new BuilderImpl());
        if (StringUtils.isEmpty(credentialsURI)) {
            throw new CredentialException("Credential URI cannot be null.");
        }
        try {
            this.credentialsURI = new URL(credentialsURI);
        }
        catch (MalformedURLException e) {
            throw new CredentialException("Credential URI is not valid.");
        }
    }

    @Deprecated
    public URLCredentialProvider(URL credentialsURI) {
        super(new BuilderImpl());
        if (credentialsURI == null) {
            throw new CredentialException("Credential URI cannot be null.");
        }
        this.credentialsURI = credentialsURI;
    }

    @Deprecated
    public URLCredentialProvider(Configuration config) {
        this(config.getCredentialsURI());
        this.connectTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
    }

    @Deprecated
    public URLCredentialProvider(Config config) {
        this(config.credentialsURI);
        this.connectTimeout = config.connectTimeout;
        this.readTimeout = config.timeout;
    }

    private URLCredentialProvider(BuilderImpl builder) {
        super(builder);
        try {
            this.credentialsURI = new URL((String)Validate.notNull((Object)builder.credentialsURI, (String)"Credentials URI is not valid.", (Object[])new Object[0]));
        }
        catch (MalformedURLException e) {
            throw new CredentialException("Credential URI is not valid.");
        }
        this.connectTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<CredentialModel> refreshCredentials() {
        Map map;
        HttpResponse response;
        CompatibleUrlConnClient client = new CompatibleUrlConnClient();
        HttpRequest request = new HttpRequest(this.credentialsURI.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectTimeout);
        request.setSysReadTimeout(this.readTimeout);
        try {
            response = client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect Server: " + e.toString());
        }
        finally {
            client.close();
        }
        if (response.getResponseCode() >= 300 || response.getResponseCode() < 200) {
            throw new CredentialException("Failed to get credentials from server: " + this.credentialsURI.toString() + "\nHttpCode=" + response.getResponseCode() + "\nHttpRAWContent=" + response.getHttpContentString());
        }
        Gson gson = new Gson();
        try {
            map = (Map)gson.fromJson(response.getHttpContentString(), Map.class);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to get credentials from server: " + this.credentialsURI.toString() + "\nHttpCode=" + response.getResponseCode() + "\nHttpRAWContent=" + response.getHttpContentString(), e);
        }
        if (map.containsKey("Code") && ((String)map.get("Code")).equals("Success")) {
            long expiration = ParameterHelper.getUTCDate((String)map.get("Expiration")).getTime();
            CredentialModel credential = CredentialModel.builder().accessKeyId((String)map.get("AccessKeyId")).accessKeySecret((String)map.get("AccessKeySecret")).securityToken((String)map.get("SecurityToken")).type("credentials_uri").expiration(expiration).build();
            return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).build();
        }
        throw new CredentialException(gson.toJson((Object)map));
    }

    public String getURL() {
        return this.credentialsURI.toString();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private static final class BuilderImpl
    extends SessionCredentialsProvider.BuilderImpl<URLCredentialProvider, Builder>
    implements Builder {
        private String credentialsURI = System.getenv("ALIBABA_CLOUD_CREDENTIALS_URI");
        private int connectionTimeout = 1000;
        private int readTimeout = 1000;

        private BuilderImpl() {
        }

        @Override
        public Builder credentialsURI(URL credentialsURI) {
            this.credentialsURI = credentialsURI.toString();
            return this;
        }

        @Override
        public Builder credentialsURI(String credentialsURI) {
            this.credentialsURI = credentialsURI;
            return this;
        }

        @Override
        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public URLCredentialProvider build() {
            return new URLCredentialProvider(this);
        }
    }

    public static interface Builder
    extends SessionCredentialsProvider.Builder<URLCredentialProvider, Builder> {
        public Builder credentialsURI(URL var1);

        public Builder credentialsURI(String var1);

        public Builder connectionTimeout(int var1);

        public Builder readTimeout(int var1);

        @Override
        public URLCredentialProvider build();
    }
}

