/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.server;

import com.navercorp.pinpoint.grpc.server.MetadataServerTransportFilter;
import com.navercorp.pinpoint.grpc.server.ServerContext;
import com.navercorp.pinpoint.grpc.server.TransportMetadata;
import io.grpc.Attributes;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportMetadataServerInterceptor
implements ServerInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Attributes attributes = serverCall.getAttributes();
        TransportMetadata transportMetadata = (TransportMetadata)attributes.get(MetadataServerTransportFilter.TRANSPORT_METADATA_KEY);
        if (transportMetadata == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Close call. cause=transportMetadata is null, headers={}, attributes={}", (Object)headers, (Object)serverCall.getAttributes());
            }
            serverCall.close(Status.INTERNAL.withDescription("transportMetadata is null"), new Metadata());
            return new ServerCall.Listener<ReqT>(){};
        }
        Context currentContext = Context.current();
        Context newContext = currentContext.withValue(ServerContext.getTransportMetadataKey(), (Object)transportMetadata);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bind metadata method={}, headers={}, attr={}", (Object)serverCall.getMethodDescriptor().getFullMethodName(), (Object)headers, (Object)serverCall.getAttributes());
        }
        ServerCall.Listener listener = Contexts.interceptCall((Context)newContext, serverCall, (Metadata)headers, serverCallHandler);
        return listener;
    }
}

