/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.http.sink.handler.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.handler.LoggerHandler;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.http.HttpWebhookConfig;
import org.apache.eventmesh.common.config.connector.http.SinkConnectorConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.http.common.SynchronizedCircularFifoQueue;
import org.apache.eventmesh.connector.http.sink.data.HttpAttemptEvent;
import org.apache.eventmesh.connector.http.sink.data.HttpConnectRecord;
import org.apache.eventmesh.connector.http.sink.data.HttpExportMetadata;
import org.apache.eventmesh.connector.http.sink.data.HttpExportRecord;
import org.apache.eventmesh.connector.http.sink.data.HttpExportRecordPage;
import org.apache.eventmesh.connector.http.sink.handler.impl.CommonHttpSinkHandler;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookHttpSinkHandler
extends CommonHttpSinkHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebhookHttpSinkHandler.class);
    private final HttpWebhookConfig webhookConfig;
    private HttpServer exportServer;
    private final SynchronizedCircularFifoQueue<HttpExportRecord> receivedDataQueue;
    private volatile boolean exportStarted = false;
    private volatile boolean exportDestroyed = false;

    public boolean isExportStarted() {
        return this.exportStarted;
    }

    public boolean isExportDestroyed() {
        return this.exportDestroyed;
    }

    public WebhookHttpSinkHandler(SinkConnectorConfig sinkConnectorConfig) {
        super(sinkConnectorConfig);
        this.webhookConfig = sinkConnectorConfig.getWebhookConfig();
        int maxQueueSize = this.webhookConfig.getMaxStorageSize();
        this.receivedDataQueue = new SynchronizedCircularFifoQueue(maxQueueSize);
        this.doInitExportServer();
    }

    private void doInitExportServer() {
        Vertx vertx = Vertx.vertx();
        Router router = Router.router((Vertx)vertx);
        router.route().handler((Handler)LoggerHandler.create());
        router.route().path(this.webhookConfig.getExportPath()).method(HttpMethod.GET).produces("application/json").handler(ctx -> {
            List<HttpExportRecord> exportRecords;
            MultiMap params = ctx.request().params();
            String pageNumStr = params.get(ParamEnum.PAGE_NUM.getValue());
            String pageSizeStr = params.get(ParamEnum.PAGE_SIZE.getValue());
            String type = params.get(ParamEnum.TYPE.getValue());
            if (type != null && !Objects.equals(type, TypeEnum.PEEK.getValue()) && !Objects.equals(type, TypeEnum.POLL.getValue()) || Objects.equals(type, TypeEnum.PEEK.getValue()) && (StringUtils.isBlank((CharSequence)pageNumStr) || Integer.parseInt(pageNumStr) < 1) || StringUtils.isBlank((CharSequence)pageSizeStr) || Integer.parseInt(pageSizeStr) < 1) {
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
                log.info("Invalid request parameters. pageNum: {}, pageSize: {}, type: {}", new Object[]{pageNumStr, pageSizeStr, type});
                return;
            }
            if (type == null) {
                type = TypeEnum.PEEK.getValue();
            }
            int pageNum = StringUtils.isBlank((CharSequence)pageNumStr) ? 1 : Integer.parseInt(pageNumStr);
            int pageSize = Integer.parseInt(pageSizeStr);
            if (this.receivedDataQueue.isEmpty()) {
                ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(HttpResponseStatus.NO_CONTENT.code()).end();
                log.info("No callback data to export.");
                return;
            }
            if (Objects.equals(type, TypeEnum.POLL.getValue())) {
                exportRecords = this.receivedDataQueue.fetchRange(0, pageSize, true);
            } else {
                int startIndex = (pageNum - 1) * pageSize;
                int endIndex = startIndex + pageSize;
                exportRecords = this.receivedDataQueue.fetchRange(startIndex, endIndex, false);
            }
            HttpExportRecordPage page = new HttpExportRecordPage(pageNum, exportRecords.size(), exportRecords);
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=utf-8").setStatusCode(HttpResponseStatus.OK.code()).send(JSON.toJSONString((Object)page, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (log.isDebugEnabled()) {
                log.debug("Succeed to export callback data. Data: {}", (Object)page);
            } else {
                log.info("Succeed to export callback data.");
            }
        });
        this.exportServer = vertx.createHttpServer(new HttpServerOptions().setPort(this.webhookConfig.getPort()).setIdleTimeout(this.webhookConfig.getServerIdleTimeout()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS)).requestHandler((Handler)router);
    }

    @Override
    public void start() {
        super.start();
        this.exportServer.listen(res -> {
            if (!res.succeeded()) {
                log.error("WebhookHttpExportServer failed to start on port: {}", (Object)this.webhookConfig.getPort());
                throw new EventMeshException("Failed to start Vertx server. ", res.cause());
            }
            this.exportStarted = true;
            log.info("WebhookHttpExportServer started on port: {}", (Object)this.webhookConfig.getPort());
        });
    }

    @Override
    public Future<HttpResponse<Buffer>> deliver(URI url, HttpConnectRecord httpConnectRecord, Map<String, Object> attributes, ConnectRecord connectRecord) {
        Future<HttpResponse<Buffer>> responseFuture = super.deliver(url, httpConnectRecord, attributes, connectRecord);
        return responseFuture.onComplete(arr -> {
            HttpAttemptEvent attemptEvent = (HttpAttemptEvent)attributes.get("http-attempt-event-" + httpConnectRecord.getHttpRecordId());
            HttpResponse response = arr.succeeded() ? (HttpResponse)arr.result() : null;
            HttpExportMetadata httpExportMetadata = this.buildHttpExportMetadata(url, (HttpResponse<Buffer>)response, httpConnectRecord, attemptEvent);
            HttpExportRecord exportRecord = new HttpExportRecord(httpExportMetadata, arr.succeeded() ? ((HttpResponse)arr.result()).bodyAsString() : null);
            this.receivedDataQueue.offer(exportRecord);
        });
    }

    private HttpExportMetadata buildHttpExportMetadata(URI url, HttpResponse<Buffer> response, HttpConnectRecord httpConnectRecord, HttpAttemptEvent attemptEvent) {
        String msg = null;
        if (attemptEvent.getLastException() != null) {
            msg = attemptEvent.getLimitedExceptionMessage();
        } else if (response != null) {
            msg = response.statusMessage();
        }
        return HttpExportMetadata.builder().url(url.toString()).code(response != null ? response.statusCode() : -1).message(msg).receivedTime(LocalDateTime.now()).recordId(httpConnectRecord.getHttpRecordId()).retryNum(attemptEvent.getAttempts() - 1).build();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.exportServer != null) {
            this.exportServer.close(res -> {
                if (!res.succeeded()) {
                    log.error("WebhookHttpExportServer failed to stop on port: {}", (Object)this.webhookConfig.getPort());
                    throw new EventMeshException("Failed to stop Vertx server. ", res.cause());
                }
                this.exportDestroyed = true;
                log.info("WebhookHttpExportServer stopped on port: {}", (Object)this.webhookConfig.getPort());
            });
        } else {
            log.warn("Callback server is null, ignore.");
        }
    }

    public static enum TypeEnum {
        POLL("poll"),
        PEEK("peek");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum ParamEnum {
        PAGE_NUM("pageNum"),
        PAGE_SIZE("pageSize"),
        TYPE("type");

        private final String value;

        private ParamEnum(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

