/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.RemoteAddressResolver;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import java.util.Collection;
import java.util.Objects;

public class HeaderResolveRequestAdaptor<T>
implements RequestAdaptor<T> {
    private final RequestAdaptor<T> delegate;
    private final RemoteAddressResolver<T> remoteAddressResolver;

    public HeaderResolveRequestAdaptor(RequestAdaptor<T> delegate, RemoteAddressResolver<T> remoteAddressResolver) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.remoteAddressResolver = Objects.requireNonNull(remoteAddressResolver, "remoteAddressResolver");
    }

    @Override
    public String getHeader(T request, String name) {
        return this.delegate.getHeader(request, name);
    }

    @Override
    public Collection<String> getHeaderNames(T request) {
        return this.delegate.getHeaderNames(request);
    }

    @Override
    public String getRpcName(T request) {
        return this.delegate.getRpcName(request);
    }

    @Override
    public String getMethodName(T request) {
        return this.delegate.getMethodName(request);
    }

    @Override
    public String getEndPoint(T request) {
        return this.delegate.getEndPoint(request);
    }

    @Override
    public String getRemoteAddress(T request) {
        String remoteAddress = this.remoteAddressResolver.resolve(this.delegate, request);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return this.delegate.getRemoteAddress(request);
    }

    @Override
    public String getAcceptorHost(T request) {
        return this.delegate.getAcceptorHost(request);
    }
}

