/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operand;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.ClassUtils;
import java.util.Objects;

@InterfaceStability.Unstable
public class ClassInternalNameMatcherOperand
extends AbstractMatcherOperand {
    private final String classInternalName;

    public ClassInternalNameMatcherOperand(String className) {
        Objects.requireNonNull(className, "className");
        this.classInternalName = ClassUtils.toInternalName((String)className);
    }

    public String getClassInternalName() {
        return this.classInternalName;
    }

    public boolean match(String classInternalName) {
        if (classInternalName == null) {
            return false;
        }
        return this.classInternalName.equals(classInternalName);
    }

    @Override
    public int getExecutionCost() {
        return 1;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("classInternalName=").append(this.classInternalName);
        sb.append('}');
        return sb.toString();
    }
}

