/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type;

import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.hibernate.dialect.Dialect;

public abstract class AbstractType<T>
implements EventMeshDataType<T> {
    protected Dialect hibernateDialect;
    protected DatabaseDialect<?> eventMeshDialect;
    private final Class<T> typeClass;
    private final SQLType sqlType;
    private final String name;

    public AbstractType(Class<T> typeClass, SQLType sqlType, String name) {
        this.typeClass = typeClass;
        this.sqlType = sqlType;
        this.name = name;
    }

    @Override
    public void configure(DatabaseDialect<?> eventMeshDialect, Dialect hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
        this.eventMeshDialect = eventMeshDialect;
    }

    @Override
    public String getTypeName(Column<?> column) {
        Long length = Optional.ofNullable(column.getColumnLength()).orElse(0L);
        return this.hibernateDialect.getTypeName(column.getJdbcType().getVendorTypeNumber().intValue(), length.longValue(), length.intValue(), Optional.ofNullable(column.getDecimal()).orElse(0).intValue());
    }

    @Override
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public SQLType getSQLType() {
        return this.sqlType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        return column.getDefaultValue() == null ? "NULL" : column.getDefaultValue().toString();
    }
}

