/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.mysql;

import lombok.Generated;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseType;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;

public class MysqlSourceMateData
extends SourceMateData {
    private int serverId;
    private String gtid;
    private String binlogFile;
    private long position;
    private String sql;

    public static MysqlSourceMateDataBuilder newBuilder() {
        return new MysqlSourceMateDataBuilder();
    }

    @Generated
    public MysqlSourceMateData() {
    }

    @Generated
    public int getServerId() {
        return this.serverId;
    }

    @Generated
    public String getGtid() {
        return this.gtid;
    }

    @Generated
    public String getBinlogFile() {
        return this.binlogFile;
    }

    @Generated
    public long getPosition() {
        return this.position;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    @Generated
    public void setGtid(String gtid) {
        this.gtid = gtid;
    }

    @Generated
    public void setBinlogFile(String binlogFile) {
        this.binlogFile = binlogFile;
    }

    @Generated
    public void setPosition(long position) {
        this.position = position;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    @Generated
    public String toString() {
        return "MysqlSourceMateData(serverId=" + this.getServerId() + ", gtid=" + this.getGtid() + ", binlogFile=" + this.getBinlogFile() + ", position=" + this.getPosition() + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MysqlSourceMateData)) {
            return false;
        }
        MysqlSourceMateData other = (MysqlSourceMateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getServerId() != other.getServerId()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        String this$gtid = this.getGtid();
        String other$gtid = other.getGtid();
        if (this$gtid == null ? other$gtid != null : !this$gtid.equals(other$gtid)) {
            return false;
        }
        String this$binlogFile = this.getBinlogFile();
        String other$binlogFile = other.getBinlogFile();
        if (this$binlogFile == null ? other$binlogFile != null : !this$binlogFile.equals(other$binlogFile)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MysqlSourceMateData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getServerId();
        long $position = this.getPosition();
        result = result * 59 + (int)($position >>> 32 ^ $position);
        String $gtid = this.getGtid();
        result = result * 59 + ($gtid == null ? 43 : $gtid.hashCode());
        String $binlogFile = this.getBinlogFile();
        result = result * 59 + ($binlogFile == null ? 43 : $binlogFile.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    public static class MysqlSourceMateDataBuilder {
        private String connector = DatabaseType.MYSQL.getCode();
        private String name;
        private long timestamp = System.currentTimeMillis();
        private boolean snapshot;
        private String catalogName;
        private String schemaName;
        private String tableName;
        private int serverId;
        private String gtid;
        private String binlogFile;
        private long position;
        private String sql;

        public MysqlSourceMateDataBuilder connector(String connector) {
            this.connector = connector;
            return this;
        }

        public MysqlSourceMateDataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MysqlSourceMateDataBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MysqlSourceMateDataBuilder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public MysqlSourceMateDataBuilder withTableId(TableId tableId) {
            this.catalogName = tableId.getCatalogName();
            this.schemaName = tableId.getSchemaName();
            this.tableName = tableId.getTableName();
            return this;
        }

        public MysqlSourceMateDataBuilder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public MysqlSourceMateDataBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public MysqlSourceMateDataBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public MysqlSourceMateDataBuilder serverId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public MysqlSourceMateDataBuilder gtid(String gtid) {
            this.gtid = gtid;
            return this;
        }

        public MysqlSourceMateDataBuilder binlogFile(String binlogFile) {
            this.binlogFile = binlogFile;
            return this;
        }

        public MysqlSourceMateDataBuilder position(long position) {
            this.position = position;
            return this;
        }

        public MysqlSourceMateDataBuilder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public MysqlSourceMateData build() {
            MysqlSourceMateData metadata = new MysqlSourceMateData();
            metadata.setConnector(this.connector);
            metadata.setName(this.name);
            metadata.setTimestamp(this.timestamp);
            metadata.setSnapshot(this.snapshot);
            metadata.setCatalogName(this.catalogName);
            metadata.setSchemaName(this.schemaName);
            metadata.setTableName(this.tableName);
            metadata.setServerId(this.serverId);
            metadata.setGtid(this.gtid);
            metadata.setBinlogFile(this.binlogFile);
            metadata.setPosition(this.position);
            metadata.setSql(this.sql);
            return metadata;
        }
    }
}

