/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParser;
import org.apache.eventmesh.connector.jdbc.antlr4.autogeneration.MySqlParserBaseListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.listener.ColumnDefinitionParserListener;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumn;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumnEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlTableEditor;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;

public class TableBaseParserListener
extends MySqlParserBaseListener {
    protected final List<ParseTreeListener> listeners;
    protected final MysqlAntlr4DdlParser parser;
    protected MysqlTableEditor tableEditor;
    protected ColumnDefinitionParserListener columnDefinitionListener;
    protected AtomicInteger columnOrder = new AtomicInteger(1);

    public TableBaseParserListener(List<ParseTreeListener> listeners, MysqlAntlr4DdlParser parser) {
        this.listeners = listeners;
        this.parser = parser;
    }

    @Override
    public void enterColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            MySqlParser.FullColumnNameContext fullColumnNameContext = ctx.fullColumnName();
            MySqlParser.UidContext uidContext = fullColumnNameContext.uid();
            List<MySqlParser.DottedIdContext> dottedIdContextList = fullColumnNameContext.dottedId();
            if (CollectionUtils.isNotEmpty(dottedIdContextList)) {
                uidContext = dottedIdContextList.get(dottedIdContextList.size() - 1).uid();
            }
            String columnName = JdbcStringUtils.withoutWrapper(uidContext.getText());
            MysqlColumnEditor columnEditor = MysqlColumnEditor.ofEditor(columnName);
            if (Objects.isNull(this.columnDefinitionListener)) {
                this.columnDefinitionListener = new ColumnDefinitionParserListener(this.listeners, this.tableEditor, columnEditor, this.parser);
                this.listeners.add(this.columnDefinitionListener);
            } else {
                this.columnDefinitionListener.setColumnEditor(columnEditor);
            }
        }, this.tableEditor);
        super.enterColumnDeclaration(ctx);
    }

    @Override
    public void exitColumnDeclaration(MySqlParser.ColumnDeclarationContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            MysqlColumnEditor columnEditor = this.columnDefinitionListener.getColumnEditor();
            columnEditor.withOrder(this.columnOrder.getAndIncrement());
            this.tableEditor.addColumns(new MysqlColumn[]{(MysqlColumn)columnEditor.build()});
        }, this.tableEditor, this.columnDefinitionListener);
        super.exitColumnDeclaration(ctx);
    }

    @Override
    public void enterPrimaryKeyTableConstraint(MySqlParser.PrimaryKeyTableConstraintContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            MySqlParser.IndexColumnNamesContext indexColumnNamesContext = ctx.indexColumnNames();
            List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameCtx -> {
                String pkColumnName = indexColumnNameCtx.uid() != null ? JdbcStringUtils.withoutWrapper(indexColumnNameCtx.uid().getText()) : (indexColumnNameCtx.STRING_LITERAL() != null ? JdbcStringUtils.withoutWrapper(indexColumnNameCtx.STRING_LITERAL().getText()) : indexColumnNameCtx.expression().getText());
                return pkColumnName;
            }).collect(Collectors.toList());
            String comment = null;
            List<MySqlParser.IndexOptionContext> indexOptionContexts = ctx.indexOption();
            for (MySqlParser.IndexOptionContext indexOptionContext : indexOptionContexts) {
                if (indexOptionContext.COMMENT() == null || indexOptionContext.STRING_LITERAL() == null) continue;
                comment = indexOptionContext.STRING_LITERAL().getText();
            }
            this.tableEditor.withPrimaryKeyNames(pkColumnNames, comment);
        }, this.tableEditor);
        super.enterPrimaryKeyTableConstraint(ctx);
    }

    @Override
    public void enterUniqueKeyTableConstraint(MySqlParser.UniqueKeyTableConstraintContext ctx) {
        this.parser.runIfAllNotNull(() -> {
            MySqlParser.IndexColumnNamesContext indexColumnNamesContext = ctx.indexColumnNames();
            List<String> ukColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameCtx -> {
                String ukColumnName = indexColumnNameCtx.uid() != null ? JdbcStringUtils.withoutWrapper(indexColumnNameCtx.uid().getText()) : (indexColumnNameCtx.STRING_LITERAL() != null ? JdbcStringUtils.withoutWrapper(indexColumnNameCtx.STRING_LITERAL().getText()) : indexColumnNameCtx.expression().getText());
                return ukColumnName;
            }).collect(Collectors.toList());
            List<MySqlParser.IndexOptionContext> indexOptionContexts = ctx.indexOption();
            String comment = null;
            if (CollectionUtils.isNotEmpty(indexOptionContexts)) {
                for (MySqlParser.IndexOptionContext context : indexOptionContexts) {
                    if (context.COMMENT() == null || context.STRING_LITERAL() == null) continue;
                    comment = context.STRING_LITERAL().getText();
                }
            }
            String ukName = ctx.index != null ? ctx.index.getText() : null;
            this.tableEditor.withUniqueKeyColumnsNames(ukName, ukColumnNames, comment);
        }, this.tableEditor);
        super.enterUniqueKeyTableConstraint(ctx);
    }
}

