/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.function;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.config.connector.SinkConfig;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.JobState;
import org.apache.eventmesh.common.remote.job.JobType;
import org.apache.eventmesh.common.remote.request.FetchJobRequest;
import org.apache.eventmesh.common.remote.request.ReportHeartBeatRequest;
import org.apache.eventmesh.common.remote.request.ReportJobRequest;
import org.apache.eventmesh.common.remote.response.FetchJobResponse;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.function.api.AbstractEventMeshFunctionChain;
import org.apache.eventmesh.function.api.EventMeshFunction;
import org.apache.eventmesh.function.filter.pattern.Pattern;
import org.apache.eventmesh.function.filter.patternbuild.PatternBuilder;
import org.apache.eventmesh.function.transformer.Transformer;
import org.apache.eventmesh.function.transformer.TransformerBuilder;
import org.apache.eventmesh.function.transformer.TransformerType;
import org.apache.eventmesh.openconnect.api.ConnectorCreateService;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.factory.ConnectorPluginFactory;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.apache.eventmesh.runtime.Runtime;
import org.apache.eventmesh.runtime.RuntimeInstanceConfig;
import org.apache.eventmesh.runtime.function.FunctionRuntimeConfig;
import org.apache.eventmesh.runtime.function.StringEventMeshFunctionChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRuntime
implements Runtime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionRuntime.class);
    private final RuntimeInstanceConfig runtimeInstanceConfig;
    private ManagedChannel channel;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;
    StreamObserver<Payload> responseObserver;
    StreamObserver<Payload> requestObserver;
    private final LinkedBlockingQueue<ConnectRecord> queue;
    private FunctionRuntimeConfig functionRuntimeConfig;
    private AbstractEventMeshFunctionChain<String, String> functionChain;
    private Sink sinkConnector;
    private Source sourceConnector;
    private final ExecutorService sourceService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sourceService");
    private final ExecutorService sinkService = ThreadPoolFactory.createSingleExecutor((String)"eventMesh-sinkService");
    private final ScheduledExecutorService heartBeatExecutor = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean isRunning = false;
    private volatile boolean isFailed = false;
    private String adminServerAddr;

    public FunctionRuntime(RuntimeInstanceConfig runtimeInstanceConfig) {
        this.runtimeInstanceConfig = runtimeInstanceConfig;
        this.queue = new LinkedBlockingQueue(1000);
    }

    @Override
    public void init() throws Exception {
        this.functionRuntimeConfig = (FunctionRuntimeConfig)ConfigService.getInstance().buildConfigInstance(FunctionRuntimeConfig.class);
        this.initAdminService();
        this.getAndUpdateRemoteConfig();
        this.initConnectorService();
        this.reportJobRequest(this.functionRuntimeConfig.getJobID(), JobState.INIT);
    }

    private void initAdminService() {
        this.adminServerAddr = this.getRandomAdminServerAddr(this.runtimeInstanceConfig.getAdminServiceAddr());
        this.channel = ManagedChannelBuilder.forTarget((String)this.adminServerAddr).usePlaintext().build();
        this.adminServiceStub = (AdminServiceGrpc.AdminServiceStub)AdminServiceGrpc.newStub((Channel)this.channel).withWaitForReady();
        this.adminServiceBlockingStub = (AdminServiceGrpc.AdminServiceBlockingStub)AdminServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady();
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.info("runtime receive message: {} ", (Object)response);
            }

            public void onError(Throwable t) {
                log.error("runtime receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("runtime finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
    }

    private String getRandomAdminServerAddr(String adminServerAddrList) {
        String[] addresses = adminServerAddrList.split(";");
        if (addresses.length == 0) {
            throw new IllegalArgumentException("Admin server address list is empty");
        }
        Random random = new Random();
        int randomIndex = random.nextInt(addresses.length);
        return addresses[randomIndex];
    }

    private void getAndUpdateRemoteConfig() {
        String jobId = this.functionRuntimeConfig.getJobID();
        FetchJobRequest jobRequest = new FetchJobRequest();
        jobRequest.setJobID(jobId);
        Metadata metadata = Metadata.newBuilder().setType(FetchJobRequest.class.getSimpleName()).build();
        Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)jobRequest)))).build()).build();
        Payload response = this.adminServiceBlockingStub.invoke(request);
        FetchJobResponse jobResponse = null;
        if (response.getMetadata().getType().equals(FetchJobResponse.class.getSimpleName())) {
            jobResponse = (FetchJobResponse)JsonUtils.parseObject((String)response.getBody().getValue().toStringUtf8(), FetchJobResponse.class);
        }
        if (jobResponse == null || jobResponse.getErrorCode() != 0) {
            if (jobResponse != null) {
                log.error("Failed to get remote config from admin server. ErrorCode: {}, Response: {}", (Object)jobResponse.getErrorCode(), (Object)jobResponse);
            } else {
                log.error("Failed to get remote config from admin server. ");
            }
            this.isFailed = true;
            try {
                this.stop();
            }
            catch (Exception e) {
                log.error("Failed to stop after exception", (Throwable)e);
            }
            throw new RuntimeException("Failed to get remote config from admin server.");
        }
        this.functionRuntimeConfig.setSourceConnectorType(jobResponse.getTransportType().getSrc().getName());
        this.functionRuntimeConfig.setSourceConnectorDesc(jobResponse.getConnectorConfig().getSourceConnectorDesc());
        this.functionRuntimeConfig.setSourceConnectorConfig(jobResponse.getConnectorConfig().getSourceConnectorConfig());
        this.functionRuntimeConfig.setSinkConnectorType(jobResponse.getTransportType().getDst().getName());
        this.functionRuntimeConfig.setSinkConnectorDesc(jobResponse.getConnectorConfig().getSinkConnectorDesc());
        this.functionRuntimeConfig.setSinkConnectorConfig(jobResponse.getConnectorConfig().getSinkConnectorConfig());
    }

    private void initConnectorService() throws Exception {
        JobType jobType = (JobType)this.functionRuntimeConfig.getRuntimeConfig().get("jobType");
        ConnectorCreateService sinkConnectorCreateService = ConnectorPluginFactory.createConnector((String)(this.functionRuntimeConfig.getSinkConnectorType() + "-Sink"));
        this.sinkConnector = (Sink)sinkConnectorCreateService.create();
        SinkConfig sinkConfig = (SinkConfig)ConfigUtil.parse(this.functionRuntimeConfig.getSinkConnectorConfig(), (Class)this.sinkConnector.configClass());
        SinkConnectorContext sinkConnectorContext = new SinkConnectorContext();
        sinkConnectorContext.setSinkConfig(sinkConfig);
        sinkConnectorContext.setRuntimeConfig(this.functionRuntimeConfig.getRuntimeConfig());
        sinkConnectorContext.setJobType(jobType);
        this.sinkConnector.init((ConnectorContext)sinkConnectorContext);
        ConnectorCreateService sourceConnectorCreateService = ConnectorPluginFactory.createConnector((String)(this.functionRuntimeConfig.getSourceConnectorType() + "-Source"));
        this.sourceConnector = (Source)sourceConnectorCreateService.create();
        SourceConfig sourceConfig = (SourceConfig)ConfigUtil.parse(this.functionRuntimeConfig.getSourceConnectorConfig(), (Class)this.sourceConnector.configClass());
        SourceConnectorContext sourceConnectorContext = new SourceConnectorContext();
        sourceConnectorContext.setSourceConfig(sourceConfig);
        sourceConnectorContext.setRuntimeConfig(this.functionRuntimeConfig.getRuntimeConfig());
        sourceConnectorContext.setJobType(jobType);
        this.sourceConnector.init((ConnectorContext)sourceConnectorContext);
    }

    private void reportJobRequest(String jobId, JobState jobState) {
        ReportJobRequest reportJobRequest = new ReportJobRequest();
        reportJobRequest.setJobID(jobId);
        reportJobRequest.setState(jobState);
        Metadata metadata = Metadata.newBuilder().setType(ReportJobRequest.class.getSimpleName()).build();
        Payload payload = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)reportJobRequest)))).build()).build();
        this.requestObserver.onNext((Object)payload);
    }

    @Override
    public void start() throws Exception {
        this.isRunning = true;
        this.functionChain = this.buildFunctionChain(this.functionRuntimeConfig.getFunctionConfigs());
        this.heartBeatExecutor.scheduleAtFixedRate(() -> {
            ReportHeartBeatRequest heartBeat = new ReportHeartBeatRequest();
            heartBeat.setAddress(IPUtils.getLocalAddress());
            heartBeat.setReportedTimeStamp(String.valueOf(System.currentTimeMillis()));
            heartBeat.setJobID(this.functionRuntimeConfig.getJobID());
            Metadata metadata = Metadata.newBuilder().setType(ReportHeartBeatRequest.class.getSimpleName()).build();
            Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)heartBeat)))).build()).build();
            this.requestObserver.onNext((Object)request);
        }, 5L, 5L, TimeUnit.SECONDS);
        this.sinkService.execute(() -> {
            try {
                this.startSinkConnector();
            }
            catch (Exception e) {
                this.isFailed = true;
                log.error("Sink Connector [{}] failed to start.", (Object)this.sinkConnector.name(), (Object)e);
                try {
                    this.stop();
                }
                catch (Exception ex) {
                    log.error("Failed to stop after exception", (Throwable)ex);
                }
                throw new RuntimeException(e);
            }
        });
        this.sourceService.execute(() -> {
            try {
                this.startSourceConnector();
            }
            catch (Exception e) {
                this.isFailed = true;
                log.error("Source Connector [{}] failed to start.", (Object)this.sourceConnector.name(), (Object)e);
                try {
                    this.stop();
                }
                catch (Exception ex) {
                    log.error("Failed to stop after exception", (Throwable)ex);
                }
                throw new RuntimeException(e);
            }
        });
        this.reportJobRequest(this.functionRuntimeConfig.getJobID(), JobState.RUNNING);
    }

    private StringEventMeshFunctionChain buildFunctionChain(List<Map<String, Object>> functionConfigs) {
        StringEventMeshFunctionChain functionChain = new StringEventMeshFunctionChain();
        for (Map<String, Object> functionConfig : functionConfigs) {
            Pattern function;
            String functionType = String.valueOf(functionConfig.getOrDefault("functionType", ""));
            if (StringUtils.isEmpty((CharSequence)functionType)) {
                throw new IllegalArgumentException("'functionType' is required for function");
            }
            switch (functionType) {
                case "filter": {
                    function = this.buildFilter(functionConfig);
                    break;
                }
                case "transformer": {
                    function = this.buildTransformer(functionConfig);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid functionType: '" + functionType + "'. Supported functionType: 'filter', 'transformer'");
                }
            }
            functionChain.addLast((EventMeshFunction)function);
        }
        return functionChain;
    }

    private Pattern buildFilter(Map<String, Object> functionConfig) {
        Object condition = functionConfig.get("condition");
        if (condition == null) {
            throw new IllegalArgumentException("'condition' is required for filter function");
        }
        if (condition instanceof String) {
            return PatternBuilder.build((String)String.valueOf(condition));
        }
        if (condition instanceof Map) {
            return PatternBuilder.build((Map)((Map)condition));
        }
        throw new IllegalArgumentException("Invalid condition");
    }

    private Transformer buildTransformer(Map<String, Object> functionConfig) {
        String transformerTypeStr = String.valueOf(functionConfig.getOrDefault("transformerType", "")).toLowerCase();
        TransformerType transformerType = TransformerType.getItem((String)transformerTypeStr);
        if (transformerType == null) {
            throw new IllegalArgumentException("Invalid transformerType: '" + transformerTypeStr + "'. Supported transformerType: 'constant', 'template', 'original' (case insensitive)");
        }
        Transformer transformer = null;
        switch (transformerType) {
            case CONSTANT: {
                String content = String.valueOf(functionConfig.getOrDefault("content", ""));
                if (StringUtils.isEmpty((CharSequence)content)) {
                    throw new IllegalArgumentException("'content' is required for constant transformer");
                }
                transformer = TransformerBuilder.buildConstantTransformer((String)content);
                break;
            }
            case TEMPLATE: {
                Object valueMap = functionConfig.get("valueMap");
                String template = String.valueOf(functionConfig.getOrDefault("template", ""));
                if (valueMap == null || StringUtils.isEmpty((CharSequence)template)) {
                    throw new IllegalArgumentException("'valueMap' and 'template' are required for template transformer");
                }
                transformer = TransformerBuilder.buildTemplateTransFormer((Object)valueMap, (String)template);
                break;
            }
            case ORIGINAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transformerType: '" + transformerType + "', supported transformerType: 'CONSTANT', 'TEMPLATE', 'ORIGINAL'");
            }
        }
        return transformer;
    }

    private void startSinkConnector() throws Exception {
        this.sinkConnector.start();
        while (this.isRunning) {
            ConnectRecord connectRecord = null;
            try {
                connectRecord = this.queue.poll(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Failed to poll data from queue.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (connectRecord == null) continue;
            this.sinkConnector.put(Collections.singletonList(connectRecord));
        }
    }

    private void startSourceConnector() throws Exception {
        this.sourceConnector.start();
        while (this.isRunning) {
            List connectorRecordList = this.sourceConnector.poll();
            if (connectorRecordList == null || connectorRecordList.isEmpty()) continue;
            for (ConnectRecord connectRecord : connectorRecordList) {
                if (connectRecord == null || connectRecord.getData() == null) {
                    this.queue.put(connectRecord);
                    continue;
                }
                String data = (String)this.functionChain.apply((Object)((String)connectRecord.getData()));
                if (data != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Function chain applied. Original data: {}, Transformed data: {}", connectRecord.getData(), (Object)data);
                    }
                    connectRecord.setData((Object)data);
                    this.queue.put(connectRecord);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Data filtered out by function chain. Original data: {}", connectRecord.getData());
            }
        }
    }

    @Override
    public void stop() throws Exception {
        log.info("FunctionRuntime is stopping...");
        this.isRunning = false;
        if (this.isFailed) {
            this.reportJobRequest(this.functionRuntimeConfig.getJobID(), JobState.FAIL);
        } else {
            this.reportJobRequest(this.functionRuntimeConfig.getJobID(), JobState.COMPLETE);
        }
        this.sinkConnector.stop();
        this.sourceConnector.stop();
        this.sinkService.shutdown();
        this.sourceService.shutdown();
        this.heartBeatExecutor.shutdown();
        this.requestObserver.onCompleted();
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown();
        }
        log.info("FunctionRuntime stopped.");
    }
}

