/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin;

import io.pravega.client.ClientConfig;
import io.pravega.client.admin.impl.ReaderGroupManagerImpl;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.stream.ConfigMismatchException;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ReaderGroupNotFoundException;
import java.net.URI;

public interface ReaderGroupManager
extends AutoCloseable {
    public static ReaderGroupManager withScope(String scope, URI controllerUri) {
        return ReaderGroupManager.withScope(scope, ClientConfig.builder().controllerURI(controllerUri).build());
    }

    public static ReaderGroupManager withScope(String scope, ClientConfig clientConfig) {
        ClientConfig updatedClientConfig = clientConfig.toBuilder().maxConnectionsPerSegmentStore(1).enableTlsToSegmentStore(clientConfig.isEnableTlsToSegmentStore()).enableTlsToController(clientConfig.isEnableTlsToController()).build();
        return new ReaderGroupManagerImpl(scope, updatedClientConfig, new SocketConnectionFactoryImpl(updatedClientConfig, 1));
    }

    public boolean createReaderGroup(String var1, ReaderGroupConfig var2) throws ConfigMismatchException;

    public void deleteReaderGroup(String var1);

    public ReaderGroup getReaderGroup(String var1) throws ReaderGroupNotFoundException;

    @Override
    public void close();
}

