/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolActivityInner;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolDatabaseActivityInner;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolInner;
import com.azure.resourcemanager.sql.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.sql.fluent.models.MetricInner;
import com.azure.resourcemanager.sql.implementation.ElasticPoolActivityImpl;
import com.azure.resourcemanager.sql.implementation.ElasticPoolDatabaseActivityImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseForElasticPoolImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseMetricDefinitionImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseMetricImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.ElasticPoolActivity;
import com.azure.resourcemanager.sql.models.ElasticPoolDatabaseActivity;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolSku;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import com.azure.resourcemanager.sql.models.Sku;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseMetric;
import com.azure.resourcemanager.sql.models.SqlDatabaseMetricDefinition;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlDatabaseStandardServiceObjective;
import com.azure.resourcemanager.sql.models.SqlElasticPool;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumSorage;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardStorage;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlElasticPoolImpl
extends ExternalChildResourceImpl<SqlElasticPool, ElasticPoolInner, SqlServerImpl, SqlServer>
implements SqlElasticPool,
SqlElasticPool.SqlElasticPoolDefinition<SqlServerImpl>,
SqlElasticPoolOperations.DefinitionStages.WithCreate,
SqlElasticPool.Update,
SqlElasticPoolOperations.SqlElasticPoolOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlServerLocation;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases;

    SqlElasticPoolImpl(String name, SqlServerImpl parent, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
        this.sqlDatabases = null;
    }

    SqlElasticPoolImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
    }

    SqlElasticPoolImpl(String name, ElasticPoolInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
    }

    public String id() {
        return ((ElasticPoolInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((ElasticPoolInner)((Object)this.innerModel())).creationDate();
    }

    @Override
    public ElasticPoolState state() {
        return ((ElasticPoolInner)((Object)this.innerModel())).state();
    }

    @Override
    public ElasticPoolEdition edition() {
        return ElasticPoolEdition.fromString(((ElasticPoolInner)((Object)this.innerModel())).sku().tier());
    }

    @Override
    public int dtu() {
        return ((ElasticPoolInner)((Object)this.innerModel())).sku().capacity();
    }

    @Override
    public Double databaseDtuMax() {
        return ((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings().maxCapacity();
    }

    @Override
    public Double databaseDtuMin() {
        return ((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings().minCapacity();
    }

    @Override
    public Long storageCapacity() {
        return ((ElasticPoolInner)((Object)this.innerModel())).maxSizeBytes();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public String regionName() {
        return this.sqlServerLocation;
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public List<ElasticPoolActivity> listActivities() {
        ArrayList<ElasticPoolActivityImpl> elasticPoolActivities = new ArrayList<ElasticPoolActivityImpl>();
        PagedIterable<ElasticPoolActivityInner> elasticPoolActivityInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPoolActivities().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        for (ElasticPoolActivityInner inner : elasticPoolActivityInners) {
            elasticPoolActivities.add(new ElasticPoolActivityImpl(inner));
        }
        return Collections.unmodifiableList(elasticPoolActivities);
    }

    @Override
    public PagedFlux<ElasticPoolActivity> listActivitiesAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPoolActivities().listByElasticPoolAsync(this.resourceGroupName, this.sqlServerName, this.name()), ElasticPoolActivityImpl::new);
    }

    @Override
    public List<ElasticPoolDatabaseActivity> listDatabaseActivities() {
        ArrayList<ElasticPoolDatabaseActivityImpl> elasticPoolDatabaseActivities = new ArrayList<ElasticPoolDatabaseActivityImpl>();
        PagedIterable<ElasticPoolDatabaseActivityInner> elasticPoolDatabaseActivityInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPoolDatabaseActivities().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        for (ElasticPoolDatabaseActivityInner inner : elasticPoolDatabaseActivityInners) {
            elasticPoolDatabaseActivities.add(new ElasticPoolDatabaseActivityImpl(inner));
        }
        return Collections.unmodifiableList(elasticPoolDatabaseActivities);
    }

    @Override
    public PagedFlux<ElasticPoolDatabaseActivity> listDatabaseActivitiesAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPoolDatabaseActivities().listByElasticPoolAsync(this.resourceGroupName, this.sqlServerName, this.name()), ElasticPoolDatabaseActivityImpl::new);
    }

    @Override
    public List<SqlDatabaseMetric> listDatabaseMetrics(String filter) {
        ArrayList<SqlDatabaseMetricImpl> databaseMetrics = new ArrayList<SqlDatabaseMetricImpl>();
        PagedIterable<MetricInner> inners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().listMetrics(this.resourceGroupName, this.sqlServerName, this.name(), filter);
        for (MetricInner inner : inners) {
            databaseMetrics.add(new SqlDatabaseMetricImpl(inner));
        }
        return Collections.unmodifiableList(databaseMetrics);
    }

    @Override
    public PagedFlux<SqlDatabaseMetric> listDatabaseMetricsAsync(String filter) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().listMetricsAsync(this.resourceGroupName, this.sqlServerName, this.name(), filter), SqlDatabaseMetricImpl::new);
    }

    @Override
    public List<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitions() {
        ArrayList<SqlDatabaseMetricDefinitionImpl> databaseMetricDefinitions = new ArrayList<SqlDatabaseMetricDefinitionImpl>();
        PagedIterable<MetricDefinitionInner> inners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().listMetricDefinitions(this.resourceGroupName, this.sqlServerName, this.name());
        for (MetricDefinitionInner inner : inners) {
            databaseMetricDefinitions.add(new SqlDatabaseMetricDefinitionImpl(inner));
        }
        return Collections.unmodifiableList(databaseMetricDefinitions);
    }

    @Override
    public PagedFlux<SqlDatabaseMetricDefinition> listDatabaseMetricDefinitionsAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().listMetricDefinitionsAsync(this.resourceGroupName, this.sqlServerName, this.name()), SqlDatabaseMetricDefinitionImpl::new);
    }

    @Override
    public List<SqlDatabase> listDatabases() {
        ArrayList<SqlDatabaseImpl> databases = new ArrayList<SqlDatabaseImpl>();
        PagedIterable<DatabaseInner> databaseInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listByElasticPool(this.resourceGroupName, this.sqlServerName, this.name());
        for (DatabaseInner inner : databaseInners) {
            databases.add(new SqlDatabaseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(databases);
    }

    @Override
    public PagedFlux<SqlDatabase> listDatabasesAsync() {
        SqlElasticPoolImpl self = this;
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listByElasticPoolAsync(self.resourceGroupName, self.sqlServerName, this.name()), databaseInner -> new SqlDatabaseImpl(self.resourceGroupName, self.sqlServerName, self.sqlServerLocation, databaseInner.name(), (DatabaseInner)((Object)databaseInner), self.sqlServerManager));
    }

    @Override
    public SqlDatabase getDatabase(String databaseName) {
        DatabaseInner databaseInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().get(this.resourceGroupName, this.sqlServerName, databaseName);
        return databaseInner != null ? new SqlDatabaseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, databaseName, databaseInner, this.sqlServerManager) : null;
    }

    @Override
    public SqlDatabase addNewDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabaseOperations.DefinitionStages.WithSqlServer)this.sqlServerManager.sqlServers().databases().define(databaseName)).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation).withExistingElasticPool(this).create();
    }

    @Override
    public SqlDatabase addExistingDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabase.Update)this.getDatabase(databaseName).update()).withExistingElasticPool(this).apply();
    }

    @Override
    public SqlDatabase addExistingDatabase(SqlDatabase database) {
        return (SqlDatabase)((SqlDatabase.Update)database.update()).withExistingElasticPool(this).apply();
    }

    @Override
    public SqlDatabase removeDatabase(String databaseName) {
        return (SqlDatabase)((SqlDatabase.Update)this.getDatabase(databaseName).update()).withoutElasticPool().withStandardEdition(SqlDatabaseStandardServiceObjective.S0).apply();
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    protected Mono<ElasticPoolInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public Mono<SqlElasticPool> createResourceAsync() {
        SqlElasticPoolImpl self = this;
        ((ElasticPoolInner)((Object)this.innerModel())).withLocation(this.sqlServerLocation);
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (ElasticPoolInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<SqlElasticPool> updateResourceAsync() {
        SqlElasticPoolImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (ElasticPoolInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    void addParentDependency(TaskGroup.HasTaskGroup parentDependency) {
        this.addDependency(parentDependency);
    }

    public void beforeGroupCreateOrUpdate() {
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (this.sqlDatabases != null) {
            this.sqlDatabases.clear();
        }
        return Mono.empty();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getElasticPools().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlElasticPool.Update update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String location) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = location;
        return this;
    }

    @Override
    public SqlElasticPoolImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    public SqlElasticPoolImpl withEdition(ElasticPoolEdition edition) {
        if (((ElasticPoolInner)((Object)this.innerModel())).sku() == null) {
            ((ElasticPoolInner)((Object)this.innerModel())).withSku(new Sku());
        }
        ((ElasticPoolInner)((Object)this.innerModel())).sku().withTier(edition.toString());
        ((ElasticPoolInner)((Object)this.innerModel())).sku().withName(edition.toString() + "Pool");
        return this;
    }

    @Override
    public SqlElasticPoolImpl withSku(ElasticPoolSku sku) {
        return this.withSku(sku.toSku());
    }

    @Override
    public SqlElasticPoolImpl withSku(Sku sku) {
        ((ElasticPoolInner)((Object)this.innerModel())).withSku(sku);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withBasicPool() {
        this.withEdition(ElasticPoolEdition.BASIC);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStandardPool() {
        this.withEdition(ElasticPoolEdition.STANDARD);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withPremiumPool() {
        this.withEdition(ElasticPoolEdition.PREMIUM);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolBasicEDTUs eDTU) {
        return this.withCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs eDTU) {
        return this.withDatabaseMaxCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs eDTU) {
        return this.withDatabaseMinCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolStandardEDTUs eDTU) {
        return this.withCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs eDTU) {
        return this.withDatabaseMaxCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs eDTU) {
        return this.withDatabaseMinCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(SqlElasticPoolStandardStorage storageCapacity) {
        this.withStorageCapacity((long)storageCapacity.capacityInMB() * 1024L * 1024L);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withReservedDtu(SqlElasticPoolPremiumEDTUs eDTU) {
        return this.withCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs eDTU) {
        return this.withDatabaseMaxCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs eDTU) {
        return this.withDatabaseMinCapacity(eDTU.value());
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(SqlElasticPoolPremiumSorage storageCapacity) {
        return this.withStorageCapacity((long)storageCapacity.capacityInMB() * 1024L * 1024L);
    }

    @Override
    public SqlElasticPoolImpl withDatabaseMinCapacity(double minCapacity) {
        if (((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings() == null) {
            ((ElasticPoolInner)((Object)this.innerModel())).withPerDatabaseSettings(new ElasticPoolPerDatabaseSettings());
        }
        ((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings().withMinCapacity(minCapacity);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withDatabaseMaxCapacity(double maxCapacity) {
        if (((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings() == null) {
            ((ElasticPoolInner)((Object)this.innerModel())).withPerDatabaseSettings(new ElasticPoolPerDatabaseSettings());
        }
        ((ElasticPoolInner)((Object)this.innerModel())).perDatabaseSettings().withMaxCapacity(maxCapacity);
        return this;
    }

    public SqlElasticPoolImpl withCapacity(int capacity) {
        if (((ElasticPoolInner)((Object)this.innerModel())).sku() == null) {
            ((ElasticPoolInner)((Object)this.innerModel())).withSku(new Sku());
        }
        ((ElasticPoolInner)((Object)this.innerModel())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withStorageCapacity(Long maxSizeBytes) {
        ((ElasticPoolInner)((Object)this.innerModel())).withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    @Override
    public SqlElasticPoolImpl withNewDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.defineInlineDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.patchUpdateDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    @Override
    public SqlElasticPoolImpl withExistingDatabase(SqlDatabase database) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.patchUpdateDatabase(database.name()).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation)).attach();
    }

    public SqlDatabaseForElasticPoolImpl defineDatabase(String databaseName) {
        if (this.sqlDatabases == null) {
            this.sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlDatabase");
        }
        return new SqlDatabaseForElasticPoolImpl(this, this.sqlDatabases.defineInlineDatabase(databaseName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation));
    }

    public SqlElasticPoolImpl withTags(Map<String, String> tags) {
        ((ElasticPoolInner)((Object)this.innerModel())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlElasticPoolImpl withTag(String key, String value) {
        if (((ElasticPoolInner)((Object)this.innerModel())).tags() == null) {
            ((ElasticPoolInner)((Object)this.innerModel())).withTags((Map)new HashMap());
        }
        ((ElasticPoolInner)((Object)this.innerModel())).tags().put(key, value);
        return this;
    }

    public SqlElasticPoolImpl withoutTag(String key) {
        if (((ElasticPoolInner)((Object)this.innerModel())).tags() != null) {
            ((ElasticPoolInner)((Object)this.innerModel())).tags().remove(key);
        }
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }
}

