/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.listener;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskInstanceLogHeader;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.ITaskExecutorRepository;
import org.apache.dolphinscheduler.task.executor.container.ITaskExecutorContainer;
import org.apache.dolphinscheduler.task.executor.container.ITaskExecutorContainerProvider;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.events.IReportableTaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.ITaskExecutorLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorDispatchedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFailedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorFinalizeLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKillLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorKilledLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPauseLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorPausedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorRuntimeContextChangedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorStartedLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.events.TaskExecutorSuccessLifecycleEvent;
import org.apache.dolphinscheduler.task.executor.exceptions.TaskExecutorNotFoundException;
import org.apache.dolphinscheduler.task.executor.listener.ITaskExecutorLifecycleEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorLifecycleEventListener
implements ITaskExecutorLifecycleEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorLifecycleEventListener.class);
    private final ITaskExecutorContainerProvider taskExecutorContainerDelegator;
    private final ITaskExecutorRepository taskExecutorRepository;
    private final ITaskExecutorLifecycleEventReporter taskExecutorLifecycleEventReporter;

    public TaskExecutorLifecycleEventListener(ITaskExecutorContainerProvider taskExecutorContainerDelegator, ITaskExecutorRepository taskExecutorRepository, ITaskExecutorLifecycleEventReporter taskExecutorLifecycleEventReporter) {
        this.taskExecutorContainerDelegator = taskExecutorContainerDelegator;
        this.taskExecutorRepository = taskExecutorRepository;
        this.taskExecutorLifecycleEventReporter = taskExecutorLifecycleEventReporter;
    }

    @Override
    public void onTaskExecutorDispatchedLifecycleEvent(TaskExecutorDispatchedLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorStartedLifecycleEvent(TaskExecutorStartedLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorRuntimeContextChangedEvent(TaskExecutorRuntimeContextChangedLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorPauseLifecycleEvent(TaskExecutorPauseLifecycleEvent event) {
        ITaskExecutor taskExecutor = this.getTaskExecutor(event);
        taskExecutor.pause();
    }

    @Override
    public void onTaskExecutorPausedLifecycleEvent(TaskExecutorPausedLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorKillLifecycleEvent(TaskExecutorKillLifecycleEvent event) {
        ITaskExecutor taskExecutor = this.getTaskExecutor(event);
        taskExecutor.kill();
    }

    @Override
    public void onTaskExecutorKilledLifecycleEvent(TaskExecutorKilledLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorSuccessLifecycleEvent(TaskExecutorSuccessLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorFailLifecycleEvent(TaskExecutorFailedLifecycleEvent event) {
        this.reportTaskExecutorLifecycleEventToMaster(event);
    }

    @Override
    public void onTaskExecutorFinalizeLifecycleEvent(TaskExecutorFinalizeLifecycleEvent event) {
        TaskInstanceLogHeader.printFinalizeTaskHeader();
        ITaskExecutor taskExecutor = this.getTaskExecutor(event);
        this.taskExecutorRepository.remove(taskExecutor.getId());
        ITaskExecutorContainer executorContainer = this.taskExecutorContainerDelegator.getExecutorContainer();
        executorContainer.finalize(taskExecutor);
    }

    private void reportTaskExecutorLifecycleEventToMaster(IReportableTaskExecutorLifecycleEvent taskExecutorLifecycleEvent) {
        this.taskExecutorLifecycleEventReporter.reportTaskExecutorLifecycleEvent(taskExecutorLifecycleEvent);
    }

    private ITaskExecutor getTaskExecutor(ITaskExecutorLifecycleEvent taskExecutorLifecycleEvent) {
        return this.taskExecutorRepository.get(taskExecutorLifecycleEvent.getTaskInstanceId()).orElseThrow(() -> new TaskExecutorNotFoundException(taskExecutorLifecycleEvent.getTaskInstanceId()));
    }
}

