/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.protocal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.protocal.Transporter;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterHeader;
import org.apache.dolphinscheduler.extract.base.serialize.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransporterDecoder
extends ReplayingDecoder<State> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransporterDecoder.class);
    private int headerLength;
    private byte[] header;
    private int bodyLength;
    private byte[] body;

    public TransporterDecoder() {
        super((Object)State.MAGIC);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case MAGIC: {
                this.checkMagic(in.readByte());
                this.checkpoint((Object)State.VERSION);
            }
            case VERSION: {
                this.checkVersion(in.readByte());
                this.checkpoint((Object)State.HEADER_LENGTH);
            }
            case HEADER_LENGTH: {
                this.headerLength = in.readInt();
                this.checkpoint((Object)State.HEADER);
            }
            case HEADER: {
                this.header = new byte[this.headerLength];
                in.readBytes(this.header);
                this.checkpoint((Object)State.BODY_LENGTH);
            }
            case BODY_LENGTH: {
                this.bodyLength = in.readInt();
                this.checkpoint((Object)State.BODY);
            }
            case BODY: {
                this.body = new byte[this.bodyLength];
                in.readBytes(this.body);
                Transporter transporter = Transporter.of(JsonSerializer.deserialize(this.header, TransporterHeader.class), this.body);
                out.add(transporter);
                this.checkpoint((Object)State.MAGIC);
                break;
            }
            default: {
                log.warn("unknown decoder state {}", this.state());
            }
        }
    }

    private void checkMagic(byte magic) {
        if (magic != -66) {
            throw new IllegalArgumentException("illegal packet [magic]" + magic);
        }
    }

    private void checkVersion(byte version) {
        if (version != 0) {
            throw new IllegalArgumentException("illegal protocol [version]" + version);
        }
    }

    static enum State {
        MAGIC,
        VERSION,
        HEADER_LENGTH,
        HEADER,
        BODY_LENGTH,
        BODY;

    }
}

