/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ExecuteSqlType {
    MIDDLE(0, "middle"),
    STATISTICS(1, "statistics"),
    COMPARISON(2, "comparison");

    private final int code;
    private final String description;
    private static final Map<Integer, ExecuteSqlType> VALUES_MAP;

    private ExecuteSqlType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ExecuteSqlType of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, ExecuteSqlType>();
        for (ExecuteSqlType type : ExecuteSqlType.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

