/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.manifests;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.spring.extended.manifests.annotation.KubectlCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class KubernetesKubectlCreateProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesKubectlCreateProcessor.class);
    private ListableBeanFactory beanFactory;
    @Autowired
    private ApiClient apiClient;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof KubernetesObject)) {
            return bean;
        }
        KubectlCreate create = (KubectlCreate)this.beanFactory.findAnnotationOnBean(beanName, KubectlCreate.class);
        if (create == null) {
            return bean;
        }
        Class<?> apiTypeClass = bean.getClass();
        try {
            log.info("@KubectlCreate ensuring resource upon bean {}", (Object)beanName);
            return this.create(apiTypeClass, bean);
        }
        catch (KubectlException e) {
            ApiException apiException;
            if (e.getCause() instanceof ApiException && 409 == (apiException = (ApiException)e.getCause()).getCode()) {
                log.info("Skipped processing {} @KubectlCreate resource already exists", (Object)beanName);
                return bean;
            }
            log.error("Failed ensuring resource from @KubectlCreate", (Throwable)e);
            throw new BeanCreationException("Failed ensuring resource from @KubectlCreate", (Throwable)e);
        }
    }

    public <ApiType extends KubernetesObject> ApiType create(Class<ApiType> apiTypeClass, Object obj) throws KubectlException {
        return (ApiType)((io.kubernetes.client.extended.kubectl.KubectlCreate)Kubectl.create(apiTypeClass).apiClient(this.apiClient)).resource((KubernetesObject)obj).execute();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

