/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.DelReviewMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.DelReviewMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class DelReviewMgrFactory {
    private static final String CLS_NM = DelReviewMgrFactory.class.getName();

    public static DelReviewMgr createInstance() throws SecurityException {
        return DelReviewMgrFactory.createInstance("HOME");
    }

    public static DelReviewMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String dReviewClassName = Config.getInstance().getProperty("delegated.reviewmgr.implementation");
        Manageable delReviewMgr = StringUtils.isEmpty((CharSequence)dReviewClassName) ? (Config.getInstance().isRestEnabled() ? new DelReviewMgrRestImpl() : new DelReviewMgrImpl()) : (DelReviewMgr)ClassUtil.createInstance(dReviewClassName);
        delReviewMgr.setContextId(contextId);
        return delReviewMgr;
    }

    public static DelReviewMgr createInstance(Session adminSess) throws SecurityException {
        return DelReviewMgrFactory.createInstance("HOME", adminSess);
    }

    public static DelReviewMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        DelReviewMgr delReviewMgr = DelReviewMgrFactory.createInstance(contextId);
        delReviewMgr.setAdmin(adminSess);
        return delReviewMgr;
    }
}

